/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.layout;

import com.powsybl.sld.layout.AbstractVoltageLevelLayout;
import com.powsybl.sld.layout.LayoutParameters;
import com.powsybl.sld.model.graphs.VoltageLevelGraph;
import com.powsybl.sld.model.nodes.BusNode;
import com.powsybl.sld.model.nodes.Node;
import java.util.Objects;
import java.util.Random;

public class RandomVoltageLevelLayout
extends AbstractVoltageLevelLayout {
    private final double width;
    private final double height;
    private final Random random;

    public RandomVoltageLevelLayout(VoltageLevelGraph graph, double width, double height, Random random) {
        super(graph);
        this.width = width;
        this.height = height;
        this.random = Objects.requireNonNull(random);
    }

    @Override
    public void run(LayoutParameters layoutParam) {
        for (Node node : this.getGraph().getNodes()) {
            node.setX(this.random.nextDouble() * this.width);
            node.setY(this.random.nextDouble() * this.height);
            if (!(node instanceof BusNode)) continue;
            ((BusNode)node).setPxWidth(50.0);
        }
        this.getGraph().setSize(this.width, this.height);
    }
}

