/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.layout;

import com.powsybl.sld.layout.GraphTraversal;
import com.powsybl.sld.layout.InternCellSide;
import com.powsybl.sld.layout.LBSCluster;
import com.powsybl.sld.layout.LegBusSet;
import com.powsybl.sld.model.cells.ExternCell;
import com.powsybl.sld.model.cells.InternCell;
import com.powsybl.sld.model.cells.ShuntCell;
import com.powsybl.sld.model.coordinate.Orientation;
import com.powsybl.sld.model.coordinate.Side;
import com.powsybl.sld.model.graphs.VoltageLevelGraph;
import com.powsybl.sld.model.nodes.BusNode;
import com.powsybl.sld.model.nodes.FeederNode;
import com.powsybl.sld.model.nodes.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Subsection {
    private int size;
    private BusNode[] busNodes;
    private Set<InternCellSide> internCellSides = new LinkedHashSet<InternCellSide>();
    private List<ExternCell> externCells = new LinkedList<ExternCell>();
    private static Comparator<ExternCell> compareOrder = Comparator.comparingInt(extCell -> extCell.getOrder().orElse(-1));

    Subsection(int size) {
        this.size = size;
        this.busNodes = new BusNode[size];
    }

    private boolean checkAbsorbability(LegBusSet lbs) {
        return lbs.getExtendedNodeSet().stream().noneMatch(busNode -> {
            int vIndex = busNode.getBusbarIndex() - 1;
            return this.busNodes[vIndex] != null && this.busNodes[vIndex] != busNode;
        });
    }

    private void addLegBusSet(LegBusSet lbs) {
        lbs.getExtendedNodeSet().forEach(bus -> {
            this.busNodes[bus.getBusbarIndex() - 1] = bus;
        });
        this.externCells.addAll(lbs.getExternCells());
        this.externCells.sort(compareOrder);
        this.internCellSides.addAll(lbs.getInternCellSides());
    }

    public int getSize() {
        return this.size;
    }

    public BusNode[] getBusNodes() {
        return this.busNodes;
    }

    BusNode getBusNode(int index) {
        return this.busNodes[index];
    }

    List<InternCell> getInternCells(InternCell.Shape shape, Side side) {
        return this.internCellSides.stream().filter(ics -> ics.getCell().checkIsShape(shape) && ics.getSide() == side).map(InternCellSide::getCell).collect(Collectors.toList());
    }

    List<InternCell> getVerticalInternCells() {
        return this.internCellSides.stream().filter(ics -> ics.getCell().checkIsShape(InternCell.Shape.VERTICAL) || ics.getCell().checkIsShape(InternCell.Shape.ONE_LEG)).map(InternCellSide::getCell).collect(Collectors.toList());
    }

    public List<ExternCell> getExternCells() {
        return this.externCells;
    }

    private boolean containsAllBusNodes(List<BusNode> nodes) {
        return Arrays.asList(this.busNodes).containsAll(nodes);
    }

    static List<Subsection> createSubsections(VoltageLevelGraph graph, LBSCluster lbsCluster, boolean handleShunts) {
        ArrayList<Subsection> subsections = new ArrayList<Subsection>();
        int vSize = graph.getMaxVerticalBusPosition();
        Subsection currentSubsection = new Subsection(vSize);
        subsections.add(currentSubsection);
        int i = 0;
        for (LegBusSet lbs : lbsCluster.getLbsList()) {
            lbs.setExtendedNodeSet(lbsCluster.getVerticalBuseNodes(i));
            if (!currentSubsection.checkAbsorbability(lbs)) {
                currentSubsection = new Subsection(vSize);
                subsections.add(currentSubsection);
            }
            currentSubsection.addLegBusSet(lbs);
            ++i;
        }
        Subsection.internCellCoherence(graph, lbsCluster.getLbsList(), subsections);
        graph.getShuntCellStream().forEach(ShuntCell::alignExternCells);
        if (handleShunts) {
            Subsection.shuntCellCoherence(graph, subsections);
        }
        return subsections;
    }

    static List<Subsection> createSubsections(VoltageLevelGraph graph, LBSCluster lbsCluster) {
        return Subsection.createSubsections(graph, lbsCluster, false);
    }

    private static void internCellCoherence(VoltageLevelGraph vlGraph, List<LegBusSet> lbsList, List<Subsection> subsections) {
        Subsection.identifyVerticalInternCells(vlGraph, subsections);
        Subsection.identifyFlatInternCells(lbsList);
        Subsection.identifyCrossOverAndCheckOrientation(subsections);
        Subsection.slipInternCellSideToEdge(subsections);
    }

    private static void identifyVerticalInternCells(VoltageLevelGraph graph, List<Subsection> subsections) {
        LinkedHashMap<InternCell, Subsection> verticalCells = new LinkedHashMap<InternCell, Subsection>();
        graph.getInternCellStream().filter(c -> c.checkIsNotShape(InternCell.Shape.ONE_LEG, InternCell.Shape.UNHANDLED_PATTERN)).forEach(c -> subsections.stream().filter(subsection -> subsection.containsAllBusNodes(c.getBusNodes())).findFirst().ifPresent(subsection -> verticalCells.putIfAbsent((InternCell)c, (Subsection)subsection)));
        verticalCells.forEach((cell, sub) -> {
            cell.setShape(InternCell.Shape.VERTICAL);
            sub.internCellSides.removeIf(ics -> ics.getCell() == cell);
            sub.internCellSides.add(new InternCellSide((InternCell)cell, Side.UNDEFINED));
        });
    }

    private static void identifyFlatInternCells(List<LegBusSet> lbsList) {
        lbsList.stream().flatMap(lbs -> lbs.getInternCellsFromShape(InternCell.Shape.MAYBE_FLAT).stream()).distinct().forEach(internCell -> {
            List<BusNode> buses = internCell.getBusNodes();
            if (Math.abs(buses.get(1).getSectionIndex() - buses.get(0).getSectionIndex()) == 1 && buses.get(1).getBusbarIndex() == buses.get(0).getBusbarIndex()) {
                internCell.setFlat();
                internCell.getRootBlock().setOrientation(Orientation.RIGHT);
            } else {
                internCell.setShape(InternCell.Shape.CROSSOVER);
            }
        });
    }

    private static void identifyCrossOverAndCheckOrientation(List<Subsection> subsections) {
        final class SideSs {
            private Side side;
            private Subsection ss;

            private SideSs(Side side, Subsection ss) {
                this.side = side;
                this.ss = ss;
            }
        }
        LinkedHashMap<InternCell, List> cellToSideSs = new LinkedHashMap<InternCell, List>();
        for (Subsection ss : subsections) {
            ss.internCellSides.stream().filter(ics -> {
                InternCell.Shape shape = ics.getCell().getShape();
                return shape == InternCell.Shape.UNDEFINED || shape == InternCell.Shape.FLAT || shape == InternCell.Shape.CROSSOVER;
            }).forEach(ics -> {
                cellToSideSs.putIfAbsent(ics.getCell(), new ArrayList());
                ((List)cellToSideSs.get(ics.getCell())).add(new SideSs(ics.getSide(), ss));
            });
        }
        cellToSideSs.forEach((cell, sideSses) -> {
            if (sideSses.size() == 2) {
                if (!cell.checkIsShape(InternCell.Shape.FLAT)) {
                    cell.setShape(InternCell.Shape.CROSSOVER);
                }
                if (((SideSs)sideSses.get((int)0)).side == Side.RIGHT) {
                    cell.reverseCell();
                    sideSses.stream().flatMap(sss -> sss.ss.internCellSides.stream()).filter(ics -> ics.getCell() == cell).forEach(InternCellSide::flipSide);
                }
            }
        });
    }

    private static void slipInternCellSideToEdge(List<Subsection> subsections) {
        LinkedHashMap<InternCellSide, Subsection> cellSideToMove = new LinkedHashMap<InternCellSide, Subsection>();
        new ArrayList<Subsection>(subsections).forEach(ss -> {
            ArrayList cellToRemove = new ArrayList();
            ss.internCellSides.stream().filter(ics -> ics.getCell().checkIsShape(InternCell.Shape.FLAT, InternCell.Shape.CROSSOVER)).forEach(ics -> {
                List<BusNode> nodes = ics.getCell().getSideBusNodes(ics.getSide());
                List candidateSss = subsections.stream().filter(ss2 -> ss2.containsAllBusNodes(nodes)).collect(Collectors.toList());
                if (!candidateSss.isEmpty()) {
                    Subsection candidateSs;
                    Subsection subsection = candidateSs = ics.getSide() == Side.LEFT ? (Subsection)candidateSss.get(candidateSss.size() - 1) : (Subsection)candidateSss.get(0);
                    if (ss != candidateSs) {
                        cellToRemove.add(ics);
                        cellSideToMove.put((InternCellSide)ics, candidateSs);
                    }
                }
            });
            ss.internCellSides.removeAll(cellToRemove);
        });
        cellSideToMove.forEach((cellSide, ss) -> ss.internCellSides.add((InternCellSide)cellSide));
    }

    private static void shuntCellCoherence(VoltageLevelGraph vlGraph, List<Subsection> subsections) {
        Map shuntCells2Buses = vlGraph.getShuntCellStream().collect(Collectors.toMap(Function.identity(), ShuntCell::getParentBusNodes, (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new));
        if (shuntCells2Buses.isEmpty()) {
            return;
        }
        List<ShuntCell> sameSubsectionShunts = Subsection.identifySameSubsectionShuntCells(subsections, shuntCells2Buses);
        Subsection.slipInternShuntedCellsToEdge(subsections, shuntCells2Buses.keySet(), sameSubsectionShunts);
        Subsection.alignMultiFeederShunt(shuntCells2Buses.keySet());
        Subsection.arrangeExternCellsOrders(subsections);
    }

    private static List<ShuntCell> identifySameSubsectionShuntCells(List<Subsection> subsections, Map<ShuntCell, List<BusNode>> shuntCells2Buses) {
        ArrayList<ShuntCell> modifiedShunts = new ArrayList<ShuntCell>();
        subsections.forEach(ss -> shuntCells2Buses.keySet().stream().filter(sc -> ss.containsAllBusNodes((List)shuntCells2Buses.get(sc))).forEach(sc -> {
            sc.getSideCells().forEach(c -> Subsection.moveExternCellToSubsection(c, ss, subsections, Side.UNDEFINED));
            int iLeft = ss.externCells.indexOf(sc.getSideCell(Side.LEFT));
            int iRight = ss.externCells.indexOf(sc.getSideCell(Side.RIGHT));
            if (iRight != iLeft + 1) {
                ExternCell leftCell = sc.getSideCell(Side.LEFT);
                ss.externCells.remove(leftCell);
                ss.externCells.add(ss.externCells.indexOf(sc.getSideCell(Side.RIGHT)), leftCell);
            }
            modifiedShunts.add((ShuntCell)sc);
        }));
        return modifiedShunts;
    }

    private static void slipInternShuntedCellsToEdge(List<Subsection> subsections, Set<ShuntCell> shuntCells, List<ShuntCell> sameSubsectionShunts) {
        shuntCells.stream().filter(sc -> !sameSubsectionShunts.contains(sc)).forEach(sc -> {
            for (Side side : Side.defined()) {
                ExternCell cell = sc.getSideCell(side);
                subsections.stream().filter(ss -> ss.containsAllBusNodes(cell.getBusNodes())).map(subsections::indexOf).mapToInt(j -> side == Side.LEFT ? j : -j.intValue()).max().ifPresent(j -> Subsection.moveExternCellToSubsection(cell, (Subsection)subsections.get(Math.abs(j)), subsections, side.getFlip()));
            }
        });
    }

    private static void moveExternCellToSubsection(ExternCell c, Subsection ss, List<Subsection> subsections, Side side) {
        if (ss.externCells.contains(c) && side == Side.UNDEFINED) {
            return;
        }
        for (Subsection sub : subsections) {
            if (!sub.externCells.contains(c)) continue;
            sub.externCells.remove(c);
            break;
        }
        if (side == Side.LEFT) {
            ss.externCells.add(0, c);
        } else {
            ss.externCells.add(c);
        }
    }

    private static void alignMultiFeederShunt(Set<ShuntCell> shCells) {
        shCells.forEach(sc -> {
            for (Side side : Side.defined()) {
                List<FeederNode> newlyOrderdFeeders;
                ExternCell cell = sc.getSideCell(side);
                List<FeederNode> feeders = cell.getFeederNodes();
                if (feeders.size() <= 1) continue;
                Node shNode = sc.getSideShuntNode(side);
                HashSet<Node> outsideNodes = new HashSet<Node>();
                outsideNodes.add(shNode);
                List<FeederNode> shuntSideFeederNodes = Subsection.buildShuntSideFeederNodes(shNode, outsideNodes);
                feeders.removeAll(shuntSideFeederNodes);
                if (side == Side.RIGHT) {
                    newlyOrderdFeeders = shuntSideFeederNodes;
                    newlyOrderdFeeders.addAll(feeders);
                } else {
                    newlyOrderdFeeders = feeders;
                    newlyOrderdFeeders.addAll(shuntSideFeederNodes);
                }
                for (int i = 0; i < newlyOrderdFeeders.size(); ++i) {
                    newlyOrderdFeeders.get(i).setOrder(i);
                }
            }
        });
    }

    private static List<FeederNode> buildShuntSideFeederNodes(Node shNode, Set<Node> outsideNodes) {
        Objects.requireNonNull(shNode);
        return shNode.getAdjacentNodes().stream().flatMap(node -> {
            LinkedHashSet<Node> gtResult = new LinkedHashSet<Node>();
            if (GraphTraversal.run(node, node1 -> node1.getType() == Node.NodeType.FEEDER, node1 -> node1.getType() == Node.NodeType.BUS, gtResult, outsideNodes)) {
                return gtResult.stream().filter(n -> n.getType() == Node.NodeType.FEEDER).map(FeederNode.class::cast);
            }
            return Stream.empty();
        }).collect(Collectors.toList());
    }

    private static void arrangeExternCellsOrders(List<Subsection> subsections) {
        subsections.forEach(ss -> {
            List<ExternCell> eCells = ss.getExternCells();
            for (int i = 1; i < eCells.size(); ++i) {
                int prevIndex = eCells.get(i - 1).getOrder().orElse(-1);
                if (eCells.get(i).getOrder().orElse(-1) > prevIndex) continue;
                eCells.get(i).setOrder(prevIndex + 1);
            }
        });
    }
}

