/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.layout;

import com.powsybl.sld.layout.GraphTraversal;
import com.powsybl.sld.layout.TopologicallyConnectedNodesSet;
import com.powsybl.sld.model.graphs.VoltageLevelGraph;
import com.powsybl.sld.model.nodes.Node;
import com.powsybl.sld.model.nodes.SwitchNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class TopologyCalculation {
    private final Predicate<Node> extremityCriteria;

    public TopologyCalculation(Predicate<Node> extremityCriteria) {
        this.extremityCriteria = extremityCriteria;
    }

    public TopologyCalculation() {
        this(TopologyCalculation::isOpenSwitchNode);
    }

    public List<TopologicallyConnectedNodesSet> findConnectedNodeSets(VoltageLevelGraph graph) {
        ArrayList<TopologicallyConnectedNodesSet> topologicallyConnectedNodesSets = new ArrayList<TopologicallyConnectedNodesSet>();
        List<Node> nodesToVisit = graph.getNodes();
        HashSet<Node> visitedNodes = new HashSet<Node>();
        Node node = TopologyCalculation.identifyNonOpenNode(nodesToVisit);
        while (node != null) {
            ArrayList<Node> borderNodes = new ArrayList<Node>();
            Set<Node> connectedNodes = this.getConnectedNodesWithExtremityNodes(node, borderNodes, visitedNodes);
            Set<Node> borderSwitchNodes = this.getBorderNodes(borderNodes, connectedNodes);
            topologicallyConnectedNodesSets.add(new TopologicallyConnectedNodesSet(new HashSet<Node>(connectedNodes), borderSwitchNodes));
            connectedNodes.removeAll(borderSwitchNodes);
            visitedNodes.addAll(connectedNodes);
            nodesToVisit.removeAll(connectedNodes);
            node = TopologyCalculation.identifyNonOpenNode(nodesToVisit);
        }
        return topologicallyConnectedNodesSets;
    }

    public List<TopologicallyConnectedNodesSet> findConnectedNodeSets(VoltageLevelGraph graph, Predicate<TopologicallyConnectedNodesSet> filter) {
        return this.findConnectedNodeSets(graph).stream().filter(filter).collect(Collectors.toList());
    }

    private Set<Node> getBorderNodes(List<Node> borderNodes, Set<Node> connectedNodes) {
        return borderNodes.stream().filter(n -> TopologyCalculation.isBorderNode(n, connectedNodes)).collect(Collectors.toSet());
    }

    private Set<Node> getConnectedNodesWithExtremityNodes(Node node, List<Node> borderNodes, Set<Node> visitedNodes) {
        return GraphTraversal.run(node, n -> {
            boolean isExtremity = this.extremityCriteria.test((Node)n);
            if (isExtremity) {
                borderNodes.add((Node)n);
            }
            return isExtremity;
        }, visitedNodes);
    }

    private static Node identifyNonOpenNode(List<Node> remainingNodes) {
        return remainingNodes.stream().filter(n -> !TopologyCalculation.isOpenSwitchNode(n)).findFirst().orElse(null);
    }

    private static boolean isBorderNode(Node borderNode, Set<Node> connectedNodes) {
        return !connectedNodes.containsAll(borderNode.getAdjacentNodes());
    }

    private static boolean isOpenSwitchNode(Node node) {
        return node.getType() == Node.NodeType.SWITCH && ((SwitchNode)node).isOpen();
    }
}

