/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.layout;

import com.powsybl.sld.layout.AbstractSubstationLayout;
import com.powsybl.sld.layout.InfosNbSnakeLinesHorizontal;
import com.powsybl.sld.layout.InfosNbSnakeLinesVertical;
import com.powsybl.sld.layout.Layout;
import com.powsybl.sld.layout.LayoutParameters;
import com.powsybl.sld.layout.VoltageLevelLayoutFactory;
import com.powsybl.sld.model.coordinate.Direction;
import com.powsybl.sld.model.coordinate.Point;
import com.powsybl.sld.model.coordinate.Side;
import com.powsybl.sld.model.graphs.BaseGraph;
import com.powsybl.sld.model.graphs.SubstationGraph;
import com.powsybl.sld.model.graphs.VoltageLevelGraph;
import com.powsybl.sld.model.nodes.Node;
import java.util.ArrayList;
import java.util.List;

public class VerticalSubstationLayout
extends AbstractSubstationLayout {
    private final InfosNbSnakeLinesVertical infosNbSnakeLines;
    private double maxVoltageLevelWidth;

    protected VerticalSubstationLayout(SubstationGraph graph, VoltageLevelLayoutFactory vLayoutFactory, InfosNbSnakeLinesVertical infosNbSnakeLines) {
        super(graph, vLayoutFactory);
        this.infosNbSnakeLines = infosNbSnakeLines;
    }

    public VerticalSubstationLayout(SubstationGraph graph, VoltageLevelLayoutFactory vLayoutFactory) {
        this(graph, vLayoutFactory, InfosNbSnakeLinesVertical.create(graph));
    }

    @Override
    protected void calculateCoordVoltageLevels(LayoutParameters layoutParameters) {
        LayoutParameters.Padding diagramPadding = layoutParameters.getDiagramPadding();
        LayoutParameters.Padding voltageLevelPadding = layoutParameters.getVoltageLevelPadding();
        double xVoltageLevels = diagramPadding.getLeft() + voltageLevelPadding.getLeft();
        double substationWidth = 0.0;
        double y = diagramPadding.getTop();
        for (VoltageLevelGraph vlGraph : this.getGraph().getVoltageLevels()) {
            Layout vLayout = this.vLayoutFactory.create(vlGraph);
            vLayout.run(layoutParameters);
            vlGraph.setCoord(xVoltageLevels, y + voltageLevelPadding.getTop());
            substationWidth = Math.max(substationWidth, vlGraph.getWidth());
            y += vlGraph.getHeight();
        }
        double substationHeight = y - diagramPadding.getTop();
        this.getGraph().setSize(substationWidth, substationHeight);
        this.maxVoltageLevelWidth = substationWidth;
    }

    @Override
    public void manageSnakeLines(LayoutParameters layoutParameters) {
        this.getGraph().getVoltageLevels().forEach(g -> this.manageSnakeLines((BaseGraph)g, layoutParameters));
        this.manageSnakeLines(this.getGraph(), layoutParameters);
        this.adaptPaddingToSnakeLines(layoutParameters);
    }

    private void adaptPaddingToSnakeLines(LayoutParameters layoutParameters) {
        double widthSnakeLinesLeft = (double)Math.max(this.infosNbSnakeLines.getNbSnakeLinesLeftRight().get((Object)Side.LEFT) - 1, 0) * layoutParameters.getHorizontalSnakeLinePadding();
        LayoutParameters.Padding diagramPadding = layoutParameters.getDiagramPadding();
        LayoutParameters.Padding voltageLevelPadding = layoutParameters.getVoltageLevelPadding();
        double xVoltageLevels = widthSnakeLinesLeft + diagramPadding.getLeft() + voltageLevelPadding.getLeft();
        double y = diagramPadding.getTop() + this.getGraph().getVoltageLevelStream().findFirst().map(vlg -> this.getHeightHorizontalSnakeLines(vlg.getId(), Direction.TOP, layoutParameters)).orElse(0.0);
        for (VoltageLevelGraph vlGraph : this.getGraph().getVoltageLevels()) {
            vlGraph.setCoord(xVoltageLevels, y + voltageLevelPadding.getTop());
            y += vlGraph.getHeight() + this.getHeightHorizontalSnakeLines(vlGraph.getId(), Direction.BOTTOM, layoutParameters);
        }
        double widthSnakeLinesRight = (double)Math.max(this.infosNbSnakeLines.getNbSnakeLinesLeftRight().get((Object)Side.RIGHT) - 1, 0) * layoutParameters.getHorizontalSnakeLinePadding();
        double substationWidth = this.getGraph().getWidth() + widthSnakeLinesLeft + widthSnakeLinesRight;
        double substationHeight = y - diagramPadding.getTop();
        this.getGraph().setSize(substationWidth, substationHeight);
        this.infosNbSnakeLines.reset();
        this.getGraph().getVoltageLevels().forEach(g -> this.manageSnakeLines((BaseGraph)g, layoutParameters));
        this.manageSnakeLines(this.getGraph(), layoutParameters);
    }

    private double getHeightHorizontalSnakeLines(String vlGraphId, Direction direction, LayoutParameters layoutParameters) {
        return (double)Math.max(this.infosNbSnakeLines.getNbSnakeLinesHorizontalBetween(vlGraphId, direction) - 1, 0) * layoutParameters.getHorizontalSnakeLinePadding();
    }

    @Override
    protected List<Point> calculatePolylineSnakeLine(LayoutParameters layoutParam, Node node1, Node node2, boolean increment) {
        if (this.getGraph().getVoltageLevelGraph(node1) == this.getGraph().getVoltageLevelGraph(node2)) {
            VoltageLevelGraph vlGraph = this.getGraph().getVoltageLevelGraph(node1);
            String graphId = vlGraph.getId();
            InfosNbSnakeLinesHorizontal infosNbSnakeLinesH = InfosNbSnakeLinesHorizontal.create(vlGraph);
            int currentNbBottom = this.infosNbSnakeLines.getNbSnakeLinesHorizontalBetween(graphId, Direction.BOTTOM);
            int currentNbTop = this.infosNbSnakeLines.getNbSnakeLinesHorizontalBetween(graphId, Direction.TOP);
            int currentNbLeft = this.infosNbSnakeLines.getNbSnakeLinesLeftRight().get((Object)Side.LEFT);
            infosNbSnakeLinesH.getNbSnakeLinesTopBottom().put(Direction.BOTTOM, currentNbBottom);
            infosNbSnakeLinesH.getNbSnakeLinesTopBottom().put(Direction.TOP, currentNbTop);
            infosNbSnakeLinesH.getNbSnakeLinesVerticalBetween().put(graphId, currentNbLeft);
            double yMin = vlGraph.getY();
            double yMax = vlGraph.getY() + vlGraph.getInnerHeight(layoutParam.getVerticalSpaceBus());
            List<Point> polyline = this.calculatePolylineSnakeLineForHorizontalLayout(layoutParam, node1, node2, increment, infosNbSnakeLinesH, yMin, yMax);
            Integer updatedNbLinesBottom = infosNbSnakeLinesH.getNbSnakeLinesTopBottom().get((Object)Direction.BOTTOM);
            Integer updatedNbLinesTop = infosNbSnakeLinesH.getNbSnakeLinesTopBottom().get((Object)Direction.TOP);
            Integer updatedNbLinesLeft = infosNbSnakeLinesH.getNbSnakeLinesVerticalBetween().get(graphId);
            this.infosNbSnakeLines.setNbSnakeLinesTopBottom(graphId, Direction.BOTTOM, updatedNbLinesBottom);
            this.infosNbSnakeLines.setNbSnakeLinesTopBottom(graphId, Direction.TOP, updatedNbLinesTop);
            this.infosNbSnakeLines.getNbSnakeLinesLeftRight().put(Side.LEFT, updatedNbLinesLeft);
            return polyline;
        }
        ArrayList<Point> polyline = new ArrayList<Point>();
        polyline.add(this.getGraph().getShiftedPoint(node1));
        this.addMiddlePoints(layoutParam, node1, node2, increment, polyline);
        polyline.add(this.getGraph().getShiftedPoint(node2));
        return polyline;
    }

    protected void addMiddlePoints(LayoutParameters layoutParam, Node node1, Node node2, boolean increment, List<Point> polyline) {
        Direction dNode1 = this.getNodeDirection(node1, 1);
        Direction dNode2 = this.getNodeDirection(node2, 2);
        String vl1 = this.getGraph().getVoltageLevelInfos(node1).getId();
        int nbSnakeLines1 = increment ? this.infosNbSnakeLines.incrementAndGetNbSnakeLinesTopBottom(vl1, dNode1) : this.infosNbSnakeLines.getNbSnakeLinesHorizontalBetween(vl1, dNode1);
        double decal1V = this.getVerticalShift(layoutParam, dNode1, nbSnakeLines1);
        Point p1 = this.getGraph().getShiftedPoint(node1);
        Point p2 = this.getGraph().getShiftedPoint(node2);
        if (this.facingNodes(node1, node2)) {
            double ySnakeLine = Math.min(p1.getY(), p2.getY()) + decal1V;
            if (p1.getX() != p2.getX()) {
                polyline.add(new Point(p1.getX(), ySnakeLine));
                polyline.add(new Point(p2.getX(), ySnakeLine));
            } else {
                polyline.add(new Point(p1.getX(), ySnakeLine));
            }
        } else {
            String vl2 = this.getGraph().getVoltageLevelInfos(node2).getId();
            int nbSnakeLines2 = this.infosNbSnakeLines.incrementAndGetNbSnakeLinesTopBottom(vl2, dNode2);
            double decal2V = this.getVerticalShift(layoutParam, dNode2, nbSnakeLines2);
            double ySnakeLine1 = this.getYSnakeLine(node1, dNode1, decal1V, layoutParam);
            double ySnakeLine2 = this.getYSnakeLine(node2, dNode2, decal2V, layoutParam);
            Side side = this.getSide(increment);
            double xSnakeLine = this.getXSnakeLine(node1, side, layoutParam);
            polyline.addAll(Point.createPointsList(p1.getX(), ySnakeLine1, xSnakeLine, ySnakeLine1, xSnakeLine, ySnakeLine2, p2.getX(), ySnakeLine2));
        }
    }

    private double getVerticalShift(LayoutParameters layoutParam, Direction dNode1, int nbSnakeLines1) {
        return (double)(nbSnakeLines1 - 1) * layoutParam.getVerticalSnakeLinePadding() + (dNode1 == Direction.TOP ? layoutParam.getVoltageLevelPadding().getTop() : layoutParam.getVoltageLevelPadding().getBottom());
    }

    private Side getSide(boolean increment) {
        return increment ? Side.LEFT : Side.RIGHT;
    }

    private double getXSnakeLine(Node node, Side side, LayoutParameters layoutParam) {
        double shiftLeftRight = (double)Math.max(this.infosNbSnakeLines.getNbSnakeLinesLeftRight().compute(side, (k, v) -> v + 1) - 1, 0) * layoutParam.getHorizontalSnakeLinePadding();
        return this.getGraph().getVoltageLevelGraph(node).getX() - layoutParam.getVoltageLevelPadding().getLeft() + (side == Side.LEFT ? -shiftLeftRight : shiftLeftRight + this.maxVoltageLevelWidth);
    }

    private double getYSnakeLine(Node node, Direction dNode1, double decalV, LayoutParameters layoutParam) {
        double y = this.getGraph().getShiftedPoint(node).getY();
        if (dNode1 == Direction.BOTTOM) {
            return y + decalV;
        }
        List<VoltageLevelGraph> vls = this.getGraph().getVoltageLevels();
        int iVl = vls.indexOf(this.getGraph().getVoltageLevelGraph(node));
        if (iVl == 0) {
            return y - decalV;
        }
        VoltageLevelGraph vlAbove = vls.get(iVl - 1);
        return vlAbove.getY() + vlAbove.getHeight() - layoutParam.getVoltageLevelPadding().getTop() - layoutParam.getVoltageLevelPadding().getBottom() + decalV;
    }

    private boolean facingNodes(Node node1, Node node2) {
        Direction dNode1 = this.getNodeDirection(node1, 1);
        Direction dNode2 = this.getNodeDirection(node2, 2);
        VoltageLevelGraph vlGraph1 = this.getGraph().getVoltageLevelGraph(node1);
        VoltageLevelGraph vlGraph2 = this.getGraph().getVoltageLevelGraph(node2);
        return dNode1 == Direction.BOTTOM && dNode2 == Direction.TOP && this.getGraph().graphAdjacents(vlGraph1, vlGraph2) || dNode1 == Direction.TOP && dNode2 == Direction.BOTTOM && this.getGraph().graphAdjacents(vlGraph2, vlGraph1);
    }
}

