/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.layout.positionbyclustering;

import com.powsybl.sld.layout.HorizontalBusLane;
import com.powsybl.sld.layout.HorizontalBusLaneManager;
import com.powsybl.sld.layout.LBSCluster;
import com.powsybl.sld.layout.positionbyclustering.LBSClusterSide;
import com.powsybl.sld.layout.positionbyclustering.Link;
import com.powsybl.sld.model.cells.AbstractCell;
import com.powsybl.sld.model.cells.InternCell;
import com.powsybl.sld.model.coordinate.Side;
import com.powsybl.sld.model.nodes.BusNode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class HBLaneManagerByClustering
implements HorizontalBusLaneManager {
    @Override
    public void mergeHorizontalBusLanes(LBSCluster leftCluster, LBSCluster rightCluster) {
        ArrayList<HorizontalBusLane> availableLanesToMerge = new ArrayList<HorizontalBusLane>(leftCluster.getHorizontalBusLanes());
        this.mergeLanesWithCommonBusNode(leftCluster, rightCluster, availableLanesToMerge);
        this.mergeLanesWithFlatCell(leftCluster, rightCluster, availableLanesToMerge);
        this.mergeLanesWithNoLink(leftCluster, rightCluster);
    }

    private void mergeLanesWithCommonBusNode(LBSCluster leftCluster, LBSCluster rightCluster, List<HorizontalBusLane> availableLanesToMerge) {
        ArrayList<BusNode> commonNodes = new ArrayList<BusNode>(leftCluster.laneSideBuses(Side.RIGHT));
        commonNodes.retainAll(rightCluster.laneSideBuses(Side.LEFT));
        commonNodes.forEach(busNode -> this.finalizeLaneBuilding(leftCluster, rightCluster, (BusNode)busNode, (BusNode)busNode, availableLanesToMerge));
    }

    private void mergeLanesWithFlatCell(LBSCluster leftCluster, LBSCluster rightCluster, List<HorizontalBusLane> availableLanesToMerge) {
        List<BusNode> myAvailableRightBuses = LBSCluster.laneSideBuses(Side.RIGHT, availableLanesToMerge);
        List myConcernedFlatCells = leftCluster.getSideCandidateFlatCell(Side.RIGHT).stream().filter(internCell -> {
            List<BusNode> nodes = internCell.getBusNodes();
            nodes.retainAll(myAvailableRightBuses);
            return !myAvailableRightBuses.isEmpty();
        }).sorted(Comparator.comparing(AbstractCell::getFullId)).collect(Collectors.toList());
        List<InternCell> otherConcernedFlatCells = rightCluster.getSideCandidateFlatCell(Side.LEFT);
        myConcernedFlatCells.retainAll(otherConcernedFlatCells);
        myConcernedFlatCells.stream().sorted(Comparator.comparingInt(cell -> Link.flatCellDistanceToEdges(cell, new LBSClusterSide(leftCluster, Side.RIGHT), new LBSClusterSide(rightCluster, Side.LEFT))).thenComparing(AbstractCell::getFullId)).forEachOrdered(internCell -> {
            BusNode myNode = this.internCellNodeInLaneSide(leftCluster, Side.RIGHT, (InternCell)internCell);
            BusNode otherNode = this.internCellNodeInLaneSide(rightCluster, Side.LEFT, (InternCell)internCell);
            if (myNode != null && otherNode != null) {
                internCell.setFlat();
                this.finalizeLaneBuilding(leftCluster, rightCluster, myNode, otherNode, availableLanesToMerge);
            }
        });
    }

    private BusNode internCellNodeInLaneSide(LBSCluster lbsCluster, Side side, InternCell cell) {
        List<BusNode> laneBuses = lbsCluster.laneSideBuses(side);
        laneBuses.retainAll(cell.getBusNodes());
        return laneBuses.isEmpty() ? null : laneBuses.get(0);
    }

    private void finalizeLaneBuilding(LBSCluster leftCluster, LBSCluster rightCluster, BusNode myNode, BusNode otherBus, List<HorizontalBusLane> availableLanesToMerge) {
        HorizontalBusLane myLane = leftCluster.getHorizontalLaneFromSideBus(myNode, Side.RIGHT);
        HorizontalBusLane otherLane = rightCluster.getHorizontalLaneFromSideBus(otherBus, Side.LEFT);
        if (otherLane != null && myLane != null) {
            myLane.merge(otherLane);
            rightCluster.removeHorizontalBusLane(otherLane);
            availableLanesToMerge.remove(myLane);
        }
    }
}

