/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.layout.positionbyclustering;

import com.powsybl.sld.layout.HorizontalBusLane;
import com.powsybl.sld.layout.LBSCluster;
import com.powsybl.sld.layout.LegBusSet;
import com.powsybl.sld.layout.positionbyclustering.Link;
import com.powsybl.sld.model.cells.ExternCell;
import com.powsybl.sld.model.cells.InternCell;
import com.powsybl.sld.model.coordinate.Side;
import com.powsybl.sld.model.nodes.BusNode;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

class LBSClusterSide {
    private final LBSCluster lbsCluster;
    private final Side side;
    private final List<Link> myLinks = new ArrayList<Link>();
    private LBSClusterSide otherSameRoot;

    LBSClusterSide(LBSCluster lbsCluster, Side side) {
        this.lbsCluster = Objects.requireNonNull(lbsCluster);
        this.side = Objects.requireNonNull(side);
    }

    void setOtherSameRoot(LBSClusterSide otherSameRoot) {
        this.otherSameRoot = otherSameRoot;
    }

    Set<BusNode> getBusNodeSet() {
        return new LinkedHashSet<BusNode>(this.lbsCluster.laneSideBuses(this.side));
    }

    List<InternCell> getCandidateFlatCellList() {
        return this.lbsCluster.getSideCandidateFlatCell(this.side);
    }

    List<ExternCell> getExternCells() {
        return this.lbsCluster.getLbsList().stream().flatMap(lbs -> lbs.getExternCells().stream()).collect(Collectors.toList());
    }

    int getExternCellAttractionToEdge(ExternCell cell) {
        List<LegBusSet> lbsList = this.lbsCluster.getLbsList();
        return lbsList.stream().filter(lbs -> lbs.getExternCells().contains(cell)).findFirst().map(lbs -> this.side == Side.LEFT ? lbsList.size() - lbsList.indexOf(lbs) : lbsList.indexOf(lbs) + 1).orElse(0);
    }

    List<InternCell> getInternCellsFromShape(InternCell.Shape shape) {
        return this.lbsCluster.getInternCellsFromShape(shape);
    }

    LBSCluster getCluster() {
        return this.lbsCluster;
    }

    Side getMySideInCluster() {
        return this.side;
    }

    boolean hasSameRoot(Object other) {
        if (other.getClass() != LBSClusterSide.class) {
            return false;
        }
        return this.lbsCluster == ((LBSClusterSide)other).getCluster();
    }

    LBSClusterSide getOtherSameRoot() {
        return this.otherSameRoot;
    }

    int getCandidateFlatCellDistanceToEdge(InternCell internCell) {
        List<BusNode> buses = internCell.getBusNodes();
        buses.retainAll(this.getBusNodeSet());
        if (buses.isEmpty()) {
            return 100;
        }
        BusNode busNode = buses.get(0);
        Optional<HorizontalBusLane> horizontalBusLane = this.lbsCluster.getHorizontalBusLanes().stream().filter(lane -> this.side == Side.LEFT && lane.getBusNodes().get(0) == busNode || this.side == Side.RIGHT && lane.getBusNodes().get(lane.getBusNodes().size() - 1) == busNode).findFirst();
        if (!horizontalBusLane.isPresent()) {
            return 100;
        }
        if (this.side == Side.LEFT) {
            return horizontalBusLane.get().getStartingIndex();
        }
        return this.lbsCluster.getLbsList().size() - horizontalBusLane.get().getEndingIndex();
    }

    void addLink(Link link) {
        this.myLinks.add(link);
    }

    void removeLink(Link link) {
        this.myLinks.remove(link);
    }

    List<Link> getLinks() {
        return this.myLinks;
    }

    public String toString() {
        return this.side.toString() + " " + this.lbsCluster.laneSideBuses(this.side).toString();
    }
}

