/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.layout.positionbyclustering;

import com.powsybl.sld.layout.HorizontalBusLaneManager;
import com.powsybl.sld.layout.positionbyclustering.LBSClusterSide;
import com.powsybl.sld.model.cells.ExternCell;
import com.powsybl.sld.model.cells.InternCell;
import com.powsybl.sld.model.cells.ShuntCell;
import com.powsybl.sld.model.coordinate.Side;
import com.powsybl.sld.model.nodes.BusNode;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

class Link
implements Comparable<Link> {
    private final LBSClusterSide lbsClusterSide1;
    private final LBSClusterSide lbsClusterSide2;
    private final Map<LinkCategory, Integer> categoryToWeight = new EnumMap<LinkCategory, Integer>(LinkCategory.class);
    private int nb;

    Link(LBSClusterSide lbsClusterSide1, LBSClusterSide lbsClusterSide2, int nb) {
        this.lbsClusterSide1 = lbsClusterSide1;
        this.lbsClusterSide2 = lbsClusterSide2;
        lbsClusterSide1.addLink(this);
        lbsClusterSide2.addLink(this);
        this.nb = nb;
        this.assessLink();
    }

    private void assessLink() {
        this.categoryToWeight.put(LinkCategory.COMMONBUSES, this.assessCommonBusNodes());
        this.categoryToWeight.put(LinkCategory.FLATCELLS, this.assessFlatCell());
        this.categoryToWeight.put(LinkCategory.CROSSOVER, this.assessCrossOver());
        this.categoryToWeight.put(LinkCategory.SHUNT, this.assessShunt());
    }

    private int assessCommonBusNodes() {
        LinkedHashSet<BusNode> nodeBusesIntersect = new LinkedHashSet<BusNode>(this.lbsClusterSide1.getBusNodeSet());
        nodeBusesIntersect.retainAll(this.lbsClusterSide2.getBusNodeSet());
        return nodeBusesIntersect.size();
    }

    private int assessFlatCell() {
        LinkedHashSet<InternCell> flatCellIntersect = new LinkedHashSet<InternCell>(this.lbsClusterSide1.getCandidateFlatCellList());
        flatCellIntersect.retainAll(this.lbsClusterSide2.getCandidateFlatCellList());
        return flatCellIntersect.size() * 100 - flatCellIntersect.stream().mapToInt(internCell -> Link.flatCellDistanceToEdges(internCell, this.lbsClusterSide1, this.lbsClusterSide2)).sum();
    }

    static int flatCellDistanceToEdges(InternCell cell, LBSClusterSide lbsCS1, LBSClusterSide lbsCS2) {
        return lbsCS1.getCandidateFlatCellDistanceToEdge(cell) + lbsCS2.getCandidateFlatCellDistanceToEdge(cell);
    }

    private int assessCrossOver() {
        LinkedHashSet<InternCell> commonInternCells = new LinkedHashSet<InternCell>(this.lbsClusterSide1.getInternCellsFromShape(InternCell.Shape.UNDEFINED));
        commonInternCells.retainAll(this.lbsClusterSide2.getInternCellsFromShape(InternCell.Shape.UNDEFINED));
        return (int)commonInternCells.stream().flatMap(internCell -> internCell.getBusNodes().stream()).distinct().count();
    }

    private int assessShunt() {
        List<ExternCell> externCells1 = this.extractExternShuntedCells(this.lbsClusterSide1);
        List<ExternCell> externCells2 = this.extractExternShuntedCells(this.lbsClusterSide2);
        List<ShuntCell> shuntCells = this.extractShuntCells(externCells1);
        shuntCells.retainAll(this.extractShuntCells(externCells2));
        List myShuntedExternCells = shuntCells.stream().flatMap(sc -> sc.getSideCells().stream()).collect(Collectors.toList());
        externCells1.retainAll(myShuntedExternCells);
        externCells2.retainAll(myShuntedExternCells);
        return this.shuntAttractivity(externCells1, this.lbsClusterSide1) + this.shuntAttractivity(externCells2, this.lbsClusterSide2);
    }

    private List<ExternCell> extractExternShuntedCells(LBSClusterSide lbsClusterSide) {
        return lbsClusterSide.getExternCells().stream().filter(ExternCell::isShunted).collect(Collectors.toList());
    }

    private List<ShuntCell> extractShuntCells(List<ExternCell> externCells) {
        return externCells.stream().map(ExternCell::getShuntCells).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private int shuntAttractivity(List<ExternCell> cells, LBSClusterSide lbsClusterSide) {
        return cells.stream().mapToInt(lbsClusterSide::getExternCellAttractionToEdge).sum();
    }

    private int getLinkCategoryWeight(LinkCategory cat) {
        return this.categoryToWeight.get((Object)cat);
    }

    LBSClusterSide getOtherlbsClusterSide(LBSClusterSide lbsClusterSide) {
        if (lbsClusterSide == this.lbsClusterSide1) {
            return this.lbsClusterSide2;
        }
        if (lbsClusterSide == this.lbsClusterSide2) {
            return this.lbsClusterSide1;
        }
        return null;
    }

    LBSClusterSide getlbsClusterSide(int i) {
        if (i == 0) {
            return this.lbsClusterSide1;
        }
        if (i == 1) {
            return this.lbsClusterSide2;
        }
        return null;
    }

    void mergeClusters(HorizontalBusLaneManager hblManager) {
        if (this.lbsClusterSide1.getCluster() == this.lbsClusterSide2.getCluster() || this.lbsClusterSide1.getMySideInCluster() == Side.UNDEFINED || this.lbsClusterSide2.getMySideInCluster() == Side.UNDEFINED) {
            return;
        }
        this.lbsClusterSide1.getCluster().merge(this.lbsClusterSide1.getMySideInCluster(), this.lbsClusterSide2.getCluster(), this.lbsClusterSide2.getMySideInCluster(), hblManager);
    }

    void removeMe() {
        this.lbsClusterSide1.removeLink(this);
        this.lbsClusterSide2.removeLink(this);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Link)) {
            return false;
        }
        return this.lbsClusterSide1.equals(((Link)obj).lbsClusterSide1) && this.lbsClusterSide2.equals(((Link)obj).lbsClusterSide2);
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public int compareTo(@Nonnull Link oLink) {
        for (LinkCategory category : LinkCategory.values()) {
            if (oLink.getLinkCategoryWeight(category) > this.getLinkCategoryWeight(category)) {
                return -1;
            }
            if (oLink.getLinkCategoryWeight(category) >= this.getLinkCategoryWeight(category)) continue;
            return 1;
        }
        return this.nb - oLink.nb;
    }

    public String toString() {
        return "CommonBus: " + this.categoryToWeight.get((Object)LinkCategory.COMMONBUSES) + " FlatCell: " + this.categoryToWeight.get((Object)LinkCategory.FLATCELLS) + " CrossOver: " + this.categoryToWeight.get((Object)LinkCategory.CROSSOVER) + " Shunt: " + this.categoryToWeight.get((Object)LinkCategory.SHUNT) + "\n\tlbsClusterSide1: " + this.lbsClusterSide1.toString() + "\n\tlbsClusterSide2: " + this.lbsClusterSide2.toString();
    }

    static enum LinkCategory {
        COMMONBUSES,
        FLATCELLS,
        CROSSOVER,
        SHUNT;

    }
}

