/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.layout.positionbyclustering;

import com.powsybl.sld.layout.HorizontalBusLaneManager;
import com.powsybl.sld.layout.LBSCluster;
import com.powsybl.sld.layout.positionbyclustering.LBSClusterSide;
import com.powsybl.sld.layout.positionbyclustering.Link;
import com.powsybl.sld.model.coordinate.Side;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;

final class Links {
    private final List<LBSClusterSide> lbsClusterSides = new LinkedList<LBSClusterSide>();
    private final TreeSet<Link> linkSet = new TreeSet();
    private HorizontalBusLaneManager hblManager;
    private int linkCounter = 0;

    private Links(HorizontalBusLaneManager hblManager) {
        this.hblManager = hblManager;
    }

    public static Links create(List<LBSCluster> lbsClusters, HorizontalBusLaneManager hblManager) {
        Links links = new Links(hblManager);
        lbsClusters.forEach(lbsCluster -> Links.addClusterSidesTwins(links, lbsCluster));
        return links;
    }

    private static void addClusterSidesTwins(Links links, LBSCluster lbsCluster) {
        LBSClusterSide lbsSLeft = new LBSClusterSide(lbsCluster, Side.LEFT);
        LBSClusterSide lbsSRight = new LBSClusterSide(lbsCluster, Side.RIGHT);
        lbsSLeft.setOtherSameRoot(lbsSRight);
        lbsSRight.setOtherSameRoot(lbsSLeft);
        links.addLBSClusterSide(lbsSLeft);
        links.addLBSClusterSide(lbsSRight);
    }

    private void addLBSClusterSide(LBSClusterSide lbsClusterSide) {
        this.lbsClusterSides.forEach(cc -> this.buildNewLink((LBSClusterSide)cc, lbsClusterSide));
        this.lbsClusterSides.add(lbsClusterSide);
    }

    private void buildNewLink(LBSClusterSide lbsClusterSide1, LBSClusterSide lbsClusterSide2) {
        if (!lbsClusterSide1.hasSameRoot(lbsClusterSide2)) {
            Link linkToAdd = new Link(lbsClusterSide1, lbsClusterSide2, this.linkCounter++);
            this.linkSet.add(linkToAdd);
        }
    }

    Link getStrongestLink() {
        return this.linkSet.last();
    }

    void mergeLink(Link link) {
        link.mergeClusters(this.hblManager);
        LBSCluster mergedCluster = link.getlbsClusterSide(0).getCluster();
        this.removeLBSClusterSide(link.getlbsClusterSide(0));
        this.removeLBSClusterSide(link.getlbsClusterSide(1));
        this.removeLBSClusterSide(link.getlbsClusterSide(0).getOtherSameRoot());
        this.removeLBSClusterSide(link.getlbsClusterSide(1).getOtherSameRoot());
        Links.addClusterSidesTwins(this, mergedCluster);
    }

    private void removeLBSClusterSide(LBSClusterSide lbsClusterSide) {
        this.lbsClusterSides.remove(lbsClusterSide);
        ArrayList<Link> linksCopy = new ArrayList<Link>(lbsClusterSide.getLinks());
        linksCopy.forEach(link -> {
            link.removeMe();
            this.linkSet.remove(link);
        });
    }

    boolean isEmpty() {
        return this.linkSet.isEmpty();
    }

    LBSCluster getFinalLBSCluster() {
        return this.lbsClusterSides.get(0).getCluster();
    }
}

