/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.layout.positionbyclustering;

import com.powsybl.sld.layout.AbstractPositionFinder;
import com.powsybl.sld.layout.HorizontalBusLane;
import com.powsybl.sld.layout.LBSCluster;
import com.powsybl.sld.layout.LegBusSet;
import com.powsybl.sld.layout.Subsection;
import com.powsybl.sld.layout.positionbyclustering.HBLaneManagerByClustering;
import com.powsybl.sld.layout.positionbyclustering.Links;
import com.powsybl.sld.model.cells.BusCell;
import com.powsybl.sld.model.cells.Cell;
import com.powsybl.sld.model.cells.ExternCell;
import com.powsybl.sld.model.cells.ShuntCell;
import com.powsybl.sld.model.coordinate.Direction;
import com.powsybl.sld.model.coordinate.Side;
import com.powsybl.sld.model.graphs.VoltageLevelGraph;
import com.powsybl.sld.model.nodes.AbstractNode;
import com.powsybl.sld.model.nodes.BusNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PositionByClustering
extends AbstractPositionFinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(PositionByClustering.class);
    private static final HBLaneManagerByClustering HBLMANAGER = new HBLaneManagerByClustering();

    @Override
    public Map<BusNode, Integer> indexBusPosition(List<BusNode> busNodes, List<BusCell> busCells) {
        LinkedHashMap<BusNode, Integer> busToNb = new LinkedHashMap<BusNode, Integer>();
        int i = 1;
        for (BusNode n : busNodes.stream().sorted(Comparator.comparing(AbstractNode::getId)).collect(Collectors.toList())) {
            busToNb.put(n, i);
            ++i;
        }
        return busToNb;
    }

    @Override
    public LBSCluster organizeLegBusSets(VoltageLevelGraph graph, List<LegBusSet> legBusSets) {
        List<LBSCluster> lbsClusters = LBSCluster.createLBSClusters(legBusSets);
        Links links = Links.create(lbsClusters, HBLMANAGER);
        while (!links.isEmpty()) {
            links.mergeLink(links.getStrongestLink());
        }
        LBSCluster lbsCluster = links.getFinalLBSCluster();
        this.tetrisHorizontalLanes(lbsCluster);
        lbsCluster.getHorizontalBusLanes().forEach(hl -> LOGGER.info(hl.toString()));
        lbsCluster.establishBusNodePosition();
        this.establishFeederPositions(lbsCluster);
        return lbsCluster;
    }

    private void tetrisHorizontalLanes(LBSCluster lbsCluster) {
        List<HorizontalBusLane> horizontalBusLanes = lbsCluster.getHorizontalBusLanes();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("{}", horizontalBusLanes);
        }
        List sortedLanes = horizontalBusLanes.stream().sorted(Comparator.comparingInt(HorizontalBusLane::getStartingIndex).thenComparing(hl -> hl.getBusNodes().get(0).getId())).collect(Collectors.toList());
        int clusterLength = sortedLanes.stream().mapToInt(HorizontalBusLane::getEndingIndex).max().orElse(0);
        block0: for (int i = 0; i < sortedLanes.size(); ++i) {
            HorizontalBusLane lane = (HorizontalBusLane)sortedLanes.get(i);
            int actualMaxIndex = lane.getEndingIndex();
            while (actualMaxIndex < clusterLength) {
                int finalActualMax = actualMaxIndex;
                HorizontalBusLane laneToAdd = sortedLanes.stream().filter(l -> l.getStartingIndex() >= finalActualMax).findFirst().orElse(null);
                if (laneToAdd != null) {
                    lane.merge(laneToAdd);
                    sortedLanes.remove(laneToAdd);
                    horizontalBusLanes.remove(laneToAdd);
                    actualMaxIndex = lane.getEndingIndex();
                    continue;
                }
                ++i;
                continue block0;
            }
        }
    }

    private void establishFeederPositions(LBSCluster lbsCluster) {
        int cellOrder = 0;
        for (LegBusSet lbs : lbsCluster.getLbsList()) {
            for (ExternCell cell : lbs.getExternCells()) {
                cell.setOrder(cellOrder++);
            }
        }
    }

    @Override
    public void organizeDirections(VoltageLevelGraph graph, List<Subsection> subsections) {
        int cellPos = 0;
        int cellShuntShift = 0;
        for (Subsection ss : subsections) {
            for (ExternCell externCell : ss.getExternCells()) {
                if (externCell.getShuntCells().stream().anyMatch(sc -> sc.getSideCell(Side.RIGHT) == externCell)) {
                    ++cellShuntShift;
                } else {
                    Direction direction = (cellPos + cellShuntShift) % 2 == 0 ? Direction.TOP : Direction.BOTTOM;
                    externCell.setDirection(direction);
                }
                ++cellPos;
            }
        }
        HashSet visitedShuntCells = new HashSet();
        graph.getShuntCellStream().forEach(shuntCell -> {
            ArrayList<ExternCell> externCells = new ArrayList<ExternCell>();
            this.shuntTraversal((ShuntCell)shuntCell, visitedShuntCells, (List<ExternCell>)externCells);
            externCells.stream().map(Cell::getDirection).filter(d -> d != Direction.UNDEFINED).findFirst().ifPresent(d -> externCells.forEach(externCell -> externCell.setDirection((Direction)((Object)((Object)d)))));
        });
    }

    private void shuntTraversal(ShuntCell shuntCell, Set<ShuntCell> visitedShuntCells, List<ExternCell> externCells) {
        if (visitedShuntCells.contains(shuntCell)) {
            return;
        }
        visitedShuntCells.add(shuntCell);
        ExternCell leftCell = shuntCell.getSideCell(Side.LEFT);
        ExternCell rightCell = shuntCell.getSideCell(Side.RIGHT);
        externCells.add(leftCell);
        externCells.add(rightCell);
        Stream.of(leftCell, rightCell).map(ExternCell::getShuntCells).flatMap(Collection::stream).filter(sc -> sc != shuntCell).forEach(sc -> this.shuntTraversal((ShuntCell)sc, visitedShuntCells, externCells));
    }
}

