/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.layout.positionfromextension;

import com.powsybl.sld.layout.HorizontalBusLane;
import com.powsybl.sld.layout.HorizontalBusLaneManager;
import com.powsybl.sld.layout.LBSCluster;
import com.powsybl.sld.model.coordinate.Side;
import com.powsybl.sld.model.nodes.BusNode;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBLaneManagerByExtension
implements HorizontalBusLaneManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(HBLaneManagerByExtension.class);

    @Override
    public void mergeHorizontalBusLanes(LBSCluster leftCluster, LBSCluster rightCluster) {
        leftCluster.getHorizontalBusLanes().forEach(hbl -> {
            BusNode rightNodeOfLeftHbl = hbl.getSideNode(Side.RIGHT);
            Optional<HorizontalBusLane> rightHBL = rightCluster.getHorizontalBusLanes().stream().filter(hbl2 -> hbl2.getSideNode(Side.LEFT).getBusbarIndex() == rightNodeOfLeftHbl.getBusbarIndex()).findFirst();
            if (rightHBL.isPresent() && (rightHBL.get().getSideNode(Side.LEFT) == rightNodeOfLeftHbl || rightNodeOfLeftHbl.getSectionIndex() < rightHBL.get().getSideNode(Side.LEFT).getSectionIndex())) {
                hbl.merge(rightHBL.get());
                rightCluster.removeHorizontalBusLane(rightHBL.get());
            } else {
                LOGGER.warn("incoherent structural horizontal positions in mergeHorizontalBusLanes");
            }
        });
        this.mergeLanesWithNoLink(leftCluster, rightCluster);
    }
}

