/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.layout.positionfromextension;

import com.powsybl.sld.layout.AbstractPositionFinder;
import com.powsybl.sld.layout.HorizontalBusLaneManager;
import com.powsybl.sld.layout.LBSCluster;
import com.powsybl.sld.layout.LegBusSet;
import com.powsybl.sld.layout.positionfromextension.HBLaneManagerByExtension;
import com.powsybl.sld.model.cells.BusCell;
import com.powsybl.sld.model.cells.Cell;
import com.powsybl.sld.model.cells.ExternCell;
import com.powsybl.sld.model.coordinate.Direction;
import com.powsybl.sld.model.coordinate.Side;
import com.powsybl.sld.model.graphs.VoltageLevelGraph;
import com.powsybl.sld.model.nodes.BusNode;
import com.powsybl.sld.model.nodes.Node;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PositionFromExtension
extends AbstractPositionFinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(PositionFromExtension.class);
    private static final Direction DEFAULTDIRECTION = Direction.TOP;
    private static final HorizontalBusLaneManager HBLMANAGER = new HBLaneManagerByExtension();
    private Comparator<LegBusSet> sortLBS = new Comparator<LegBusSet>(){

        @Override
        public int compare(LegBusSet lbs1, LegBusSet lbs2) {
            int v2max;
            int h2max;
            for (BusNode busNode : lbs1.getBusNodeSet()) {
                Optional<Integer> optionalSectionIndex2 = lbs2.getBusNodeSet().stream().filter(busNode2 -> busNode2.getBusbarIndex() == busNode.getBusbarIndex()).findFirst().map(BusNode::getSectionIndex);
                if (!optionalSectionIndex2.isPresent() || optionalSectionIndex2.get().intValue() == busNode.getSectionIndex()) continue;
                return busNode.getSectionIndex() - optionalSectionIndex2.get();
            }
            Optional<Integer> order1 = this.externCellOrderNb(lbs1);
            Optional<Integer> order2 = this.externCellOrderNb(lbs2);
            if (order1.isPresent() && order2.isPresent()) {
                return order1.get() - order2.get();
            }
            int h1max = this.getMaxPos(lbs1.getBusNodeSet(), BusNode::getSectionIndex);
            if (h1max != (h2max = this.getMaxPos(lbs2.getBusNodeSet(), BusNode::getSectionIndex))) {
                return h1max - h2max;
            }
            int v1max = this.getMaxPos(lbs1.getBusNodeSet(), BusNode::getBusbarIndex);
            if (v1max != (v2max = this.getMaxPos(lbs2.getBusNodeSet(), BusNode::getBusbarIndex))) {
                return v1max - v2max;
            }
            return lbs1.getBusNodeSet().size() - lbs2.getBusNodeSet().size();
        }

        private int getMaxPos(Set<BusNode> busNodes, Function<BusNode, Integer> fun) {
            return busNodes.stream().map(fun).max(Integer::compareTo).orElse(0);
        }

        private Optional<Integer> externCellOrderNb(LegBusSet lbs) {
            return lbs.getExternCells().stream().findAny().map(exCell -> exCell.getOrder().orElse(-1));
        }
    };

    @Override
    public Map<BusNode, Integer> indexBusPosition(List<BusNode> busNodes, List<BusCell> busCells) {
        HashMap<BusNode, Integer> busToNb = new HashMap<BusNode, Integer>();
        PositionFromExtension.setMissingPositionIndices(busNodes, busCells);
        List busNodesSorted = busNodes.stream().sorted(Comparator.comparingInt(BusNode::getBusbarIndex).thenComparing(BusNode::getSectionIndex)).collect(Collectors.toList());
        int i = 1;
        for (BusNode busNode : busNodesSorted) {
            busToNb.put(busNode, i++);
        }
        return busToNb;
    }

    private static void setMissingPositionIndices(List<BusNode> busNodes, List<BusCell> busCells) {
        List missingIndicesBusNodes = busNodes.stream().filter(busNode -> busNode.getBusbarIndex() <= 0 || busNode.getSectionIndex() <= 0).collect(Collectors.toList());
        if (!missingIndicesBusNodes.isEmpty()) {
            int maxSectionIndex = busNodes.stream().mapToInt(BusNode::getSectionIndex).max().orElse(0);
            for (BusNode busNode2 : missingIndicesBusNodes) {
                PositionFromExtension.setMissingPositionIndices(busNode2, busNodes, busCells, maxSectionIndex);
                maxSectionIndex = Math.max(maxSectionIndex, busNode2.getSectionIndex());
            }
        }
    }

    private static void setMissingPositionIndices(BusNode busNode, List<BusNode> busNodes, List<BusCell> busCells, int maxSectionIndex) {
        int newSectionIndex = maxSectionIndex + 1;
        int newBusbarIndex = 1;
        for (BusCell busCell : busCells) {
            int section;
            List<BusNode> cellBusNodes = busCell.getBusNodes();
            if (!cellBusNodes.contains(busNode) || (section = cellBusNodes.stream().mapToInt(BusNode::getSectionIndex).max().getAsInt()) <= 0) continue;
            newSectionIndex = section;
            newBusbarIndex = 1 + busNodes.stream().filter(bn -> bn.getSectionIndex() == section).mapToInt(BusNode::getBusbarIndex).max().orElse(0);
            break;
        }
        LOGGER.warn("Incoherent position extension on busbar {} (busbar index: {}, section index: {}): setting busbar index to {} and section index to {}", new Object[]{busNode.getId(), busNode.getBusbarIndex(), busNode.getSectionIndex(), newBusbarIndex, newSectionIndex});
        busNode.setBusBarIndexSectionIndex(newBusbarIndex, newSectionIndex);
    }

    @Override
    public LBSCluster organizeLegBusSets(VoltageLevelGraph graph, List<LegBusSet> legBusSets) {
        this.gatherLayoutExtensionInformation(graph);
        List<LBSCluster> lbsClusters = LBSCluster.createLBSClusters(legBusSets.stream().sorted(this.sortLBS).collect(Collectors.toList()));
        LBSCluster lbsCluster = lbsClusters.get(0);
        while (lbsClusters.size() != 1) {
            lbsCluster.merge(Side.RIGHT, lbsClusters.get(1), Side.LEFT, HBLMANAGER);
            lbsClusters.remove(1);
        }
        lbsCluster.sortHorizontalBusLanesByVPos();
        return lbsCluster;
    }

    private void gatherLayoutExtensionInformation(VoltageLevelGraph graph) {
        graph.getBusCellStream().forEach(bc -> {
            PositionFromExtension.setDirection(bc);
            PositionFromExtension.setOrder(bc);
        });
        List<ExternCell> problematicCells = graph.getExternCellStream().filter(cell -> cell.getOrder().isEmpty()).collect(Collectors.toList());
        if (!problematicCells.isEmpty()) {
            LOGGER.warn("Unable to build the layout only with Extension\nproblematic cells :");
            problematicCells.forEach(cell -> LOGGER.info("Cell Nb : {}, Order : {}, Type : {}", new Object[]{cell.getNumber(), cell.getOrder().orElse(null), cell.getType()}));
        }
    }

    private static void setDirection(BusCell bc) {
        List listOfDirectionsInsideCell = bc.getNodes().stream().map(Node::getDirection).filter(d -> d != Direction.UNDEFINED).distinct().collect(Collectors.toList());
        int numberOfDirectionsInsideCell = listOfDirectionsInsideCell.size();
        if (numberOfDirectionsInsideCell == 0) {
            if (bc.getType() == Cell.CellType.EXTERN) {
                bc.setDirection(DEFAULTDIRECTION);
            }
        } else {
            bc.setDirection((Direction)((Object)listOfDirectionsInsideCell.get(0)));
            if (numberOfDirectionsInsideCell > 1) {
                LOGGER.warn("Directions inside cell are not consistent: {} directions found instead of 1", (Object)numberOfDirectionsInsideCell);
            }
        }
    }

    private static void setOrder(BusCell bc) {
        bc.getNodes().stream().map(Node::getOrder).filter(Optional::isPresent).mapToInt(Optional::get).min().ifPresent(bc::setOrder);
    }
}

