/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.library;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.powsybl.sld.library.AnchorOrientation;
import com.powsybl.sld.library.Component;
import com.powsybl.sld.model.coordinate.Orientation;
import com.powsybl.sld.model.coordinate.Point;
import java.util.Objects;

public class AnchorPoint
extends Point {
    private final AnchorOrientation orientation;

    @JsonCreator
    public AnchorPoint(@JsonProperty(value="x") double x, @JsonProperty(value="y") double y, @JsonProperty(value="orientation") AnchorOrientation orientation) {
        super(x, y);
        this.orientation = Objects.requireNonNull(orientation);
    }

    public AnchorOrientation getOrientation() {
        return this.orientation;
    }

    public AnchorPoint transformAnchorPoint(Orientation nodeOrientation, Component.Transformation nodeTransformation) {
        if (nodeTransformation == Component.Transformation.ROTATION) {
            if (nodeOrientation.isHorizontal()) {
                AnchorOrientation newOrientation;
                AnchorOrientation anchorOrientation = newOrientation = this.orientation == AnchorOrientation.HORIZONTAL ? AnchorOrientation.VERTICAL : AnchorOrientation.HORIZONTAL;
                if (nodeOrientation == Orientation.RIGHT) {
                    return new AnchorPoint(-this.getY(), -this.getX(), newOrientation);
                }
                return new AnchorPoint(this.getY(), this.getX(), newOrientation);
            }
            if (nodeOrientation == Orientation.DOWN) {
                return new AnchorPoint(-this.getX(), -this.getY(), this.orientation);
            }
            return new AnchorPoint(this.getX(), this.getY(), this.orientation);
        }
        if (nodeTransformation == Component.Transformation.FLIP && nodeOrientation == Orientation.DOWN) {
            return new AnchorPoint(this.getX(), -this.getY(), this.orientation);
        }
        return this;
    }

    @Override
    public String toString() {
        return "AnchorPoint(x=" + this.getX() + ", y=" + this.getY() + ", orientation=" + this.orientation + ")";
    }
}

