/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.library;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.powsybl.sld.library.AnchorPoint;
import com.powsybl.sld.library.ComponentSize;
import com.powsybl.sld.library.SubComponent;
import com.powsybl.sld.model.coordinate.Orientation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class Component {
    private final String type;
    private final List<AnchorPoint> anchorPoints;
    private final ComponentSize size;
    private final String styleClass;
    private final Map<Orientation, Transformation> transformations;
    private final List<SubComponent> subComponents;

    @JsonCreator
    public Component(@JsonProperty(value="type") String type, @JsonProperty(value="anchorPoints") List<AnchorPoint> anchorPoints, @JsonProperty(value="size") ComponentSize size, @JsonProperty(value="style") String styleClass, @JsonProperty(value="transformations") Map<Orientation, Transformation> transformations, @JsonProperty(value="subComponents") List<SubComponent> subComponents) {
        this.type = Objects.requireNonNull(type);
        this.anchorPoints = Collections.unmodifiableList(Objects.requireNonNullElse(anchorPoints, Collections.emptyList()));
        this.size = Objects.requireNonNullElse(size, new ComponentSize(0.0, 0.0));
        this.styleClass = styleClass;
        this.transformations = Objects.requireNonNullElse(transformations, Collections.emptyMap());
        this.subComponents = Collections.unmodifiableList(Objects.requireNonNullElse(subComponents, Collections.emptyList()));
    }

    public String getType() {
        return this.type;
    }

    public ComponentSize getSize() {
        return this.size;
    }

    public List<AnchorPoint> getAnchorPoints() {
        return this.anchorPoints;
    }

    public Map<Orientation, Transformation> getTransformations() {
        return this.transformations;
    }

    public List<SubComponent> getSubComponents() {
        return this.subComponents;
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public static enum Transformation {
        ROTATION,
        FLIP,
        NONE;

    }
}

