/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.library;

import com.google.common.collect.Lists;
import com.powsybl.sld.library.AnchorPoint;
import com.powsybl.sld.library.Component;
import com.powsybl.sld.library.ComponentSize;
import com.powsybl.sld.model.coordinate.Orientation;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import org.w3c.dom.Element;

public interface ComponentLibrary {
    public static List<ComponentLibrary> findAll() {
        return Lists.newArrayList(ServiceLoader.load(ComponentLibrary.class));
    }

    public static Optional<ComponentLibrary> find(String name) {
        Objects.requireNonNull(name);
        return ComponentLibrary.findAll().stream().filter(cl -> cl.getName().equals(name)).findFirst();
    }

    public String getName();

    public List<AnchorPoint> getAnchorPoints(String var1);

    public Map<String, List<Element>> getSvgElements(String var1);

    public ComponentSize getSize(String var1);

    public Map<Orientation, Component.Transformation> getTransformations(String var1);

    public Map<String, ComponentSize> getComponentsSize();

    public List<String> getCssFilenames();

    public List<URL> getCssUrls();

    public Optional<String> getComponentStyleClass(String var1);

    public Optional<String> getSubComponentStyleClass(String var1, String var2);
}

