/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.library;

import com.fasterxml.jackson.databind.ObjectReader;
import com.powsybl.commons.json.JsonUtil;
import com.powsybl.sld.library.Component;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Components {
    private final List<Component> loadedComponents = new ArrayList<Component>();

    public List<Component> getComponents() {
        return this.loadedComponents;
    }

    public static Components load(String directory) {
        return Components.load(Components.class.getResourceAsStream(directory + "/components.json"));
    }

    public static Components load(InputStream is) {
        Components components;
        Objects.requireNonNull(is);
        InputStreamReader reader = new InputStreamReader(is);
        try {
            components = Components.load(reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        ((Reader)reader).close();
        return components;
    }

    public static Components load(Reader reader) throws IOException {
        Objects.requireNonNull(reader);
        ObjectReader objectReader = JsonUtil.createObjectMapper().readerFor(Components.class);
        return (Components)objectReader.readValue(reader);
    }
}

