/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.library;

import com.powsybl.commons.exceptions.UncheckedSaxException;
import com.powsybl.sld.library.AnchorOrientation;
import com.powsybl.sld.library.AnchorPoint;
import com.powsybl.sld.library.Component;
import com.powsybl.sld.library.ComponentLibrary;
import com.powsybl.sld.library.ComponentSize;
import com.powsybl.sld.library.Components;
import com.powsybl.sld.library.SubComponent;
import com.powsybl.sld.model.coordinate.Orientation;
import com.powsybl.sld.util.DomUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ResourcesComponentLibrary
implements ComponentLibrary {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourcesComponentLibrary.class);
    private final String name;
    private final Map<String, Map<String, List<Element>>> svgDocuments = new HashMap<String, Map<String, List<Element>>>();
    private final Map<String, Component> components = new HashMap<String, Component>();
    private final List<String> cssFilenames = new ArrayList<String>();
    private final List<URL> cssUrls = new ArrayList<URL>();

    public ResourcesComponentLibrary(String name, String directory, String ... additionalDirectories) {
        this.name = Objects.requireNonNull(name);
        Objects.requireNonNull(directory);
        this.loadLibrary(directory);
        for (String addDir : additionalDirectories) {
            this.loadLibrary(addDir);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void loadLibrary(String directory) {
        LOGGER.info("Loading component library from {}...", (Object)directory);
        DocumentBuilder db = DomUtil.getDocumentBuilder();
        Components.load(directory).getComponents().forEach(c -> {
            String componentType = c.getType();
            c.getSubComponents().forEach(s -> {
                String resourceName = directory + "/" + s.getFileName();
                LOGGER.debug("Reading subComponent {}", (Object)resourceName);
                try {
                    Document doc = db.parse(this.getClass().getResourceAsStream(resourceName));
                    this.svgDocuments.computeIfAbsent(componentType, k -> new TreeMap()).put(s.getName(), this.getElements(doc));
                }
                catch (SAXException e) {
                    throw new UncheckedSaxException(e);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            this.components.put(componentType, (Component)c);
        });
        this.cssFilenames.add(FilenameUtils.getName((String)directory) + "_components.css");
        this.cssUrls.add(this.getClass().getResource(directory + "/components.css"));
    }

    protected List<Element> getElements(Document doc) {
        Node svgNode = doc.getChildNodes().item(0);
        ArrayList<Element> elements = new ArrayList<Element>();
        NodeList subComponentChildren = svgNode.getChildNodes();
        for (int i = 0; i < subComponentChildren.getLength(); ++i) {
            Node n = subComponentChildren.item(i);
            if (!(n instanceof Element)) continue;
            elements.add((Element)n.cloneNode(true));
        }
        return elements;
    }

    @Override
    public Map<String, List<Element>> getSvgElements(String type) {
        Objects.requireNonNull(type);
        Map<String, List<Element>> result = this.svgDocuments.get(type);
        if (result == null && this.isDisplayed(type)) {
            result = this.svgDocuments.get("UNKNOWN_COMPONENT");
        }
        return result;
    }

    @Override
    public List<AnchorPoint> getAnchorPoints(String type) {
        Objects.requireNonNull(type);
        Component component = this.getComponent(type);
        return component != null ? component.getAnchorPoints() : Collections.singletonList(new AnchorPoint(0.0, 0.0, AnchorOrientation.NONE));
    }

    @Override
    public ComponentSize getSize(String type) {
        Objects.requireNonNull(type);
        Component component = this.getComponent(type);
        return component != null ? component.getSize() : new ComponentSize(0.0, 0.0);
    }

    @Override
    public Map<String, ComponentSize> getComponentsSize() {
        HashMap<String, ComponentSize> res = new HashMap<String, ComponentSize>();
        this.components.forEach((key, value) -> res.put((String)key, value.getSize()));
        return res;
    }

    @Override
    public List<String> getCssFilenames() {
        return this.cssFilenames;
    }

    @Override
    public List<URL> getCssUrls() {
        return this.cssUrls;
    }

    @Override
    public Optional<String> getComponentStyleClass(String type) {
        Objects.requireNonNull(type);
        Component component = this.getComponent(type);
        return component != null ? Optional.ofNullable(component.getStyleClass()) : Optional.empty();
    }

    @Override
    public Optional<String> getSubComponentStyleClass(String type, String subComponent) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(subComponent);
        Component component = this.getComponent(type);
        if (component != null) {
            return component.getSubComponents().stream().filter(sc -> sc.getName().equals(subComponent)).findFirst().map(SubComponent::getStyleClass);
        }
        return Optional.empty();
    }

    @Override
    public Map<Orientation, Component.Transformation> getTransformations(String type) {
        Objects.requireNonNull(type);
        Component component = this.getComponent(type);
        return component != null ? component.getTransformations() : Collections.emptyMap();
    }

    protected Component getComponent(String type) {
        Objects.requireNonNull(type);
        Component component = this.components.get(type);
        if (component == null && this.isDisplayed(type)) {
            component = this.components.get("UNKNOWN_COMPONENT");
        }
        return component;
    }

    protected boolean isDisplayed(String componentType) {
        return !componentType.equals("PHASE_SHIFT_TRANSFORMER_LEG") && !componentType.equals("TWO_WINDINGS_TRANSFORMER_LEG") && !componentType.equals("THREE_WINDINGS_TRANSFORMER_LEG") && !componentType.equals("LINE") && !componentType.equals("DANGLING_LINE") && !componentType.equals("BUSBAR_SECTION");
    }
}

