/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.model.blocks;

import com.fasterxml.jackson.core.JsonGenerator;
import com.powsybl.sld.model.blocks.Block;
import com.powsybl.sld.model.coordinate.Coord;
import com.powsybl.sld.model.coordinate.Orientation;
import com.powsybl.sld.model.coordinate.Position;
import com.powsybl.sld.model.nodes.Node;
import java.io.IOException;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public abstract class AbstractBlock
implements Block {
    protected final Block.Type type;
    private Map<Block.Extremity, Integer> cardinality = new EnumMap<Block.Extremity, Integer>(Block.Extremity.class);
    private Block parentBlock;
    private Position position;
    private Coord coord;

    AbstractBlock(Block.Type type) {
        this.cardinality.put(Block.Extremity.START, 0);
        this.cardinality.put(Block.Extremity.END, 0);
        this.type = Objects.requireNonNull(type);
        this.position = new Position(-1, -1);
        this.coord = new Coord(-1.0, -1.0);
    }

    @Override
    public Node getStartingNode() {
        return this.getExtremityNode(Block.Extremity.START);
    }

    @Override
    public Node getEndingNode() {
        return this.getExtremityNode(Block.Extremity.END);
    }

    @Override
    public Optional<Block.Extremity> getExtremity(Node node) {
        if (node.equals(this.getExtremityNode(Block.Extremity.START))) {
            return Optional.of(Block.Extremity.START);
        }
        if (node.equals(this.getExtremityNode(Block.Extremity.END))) {
            return Optional.of(Block.Extremity.END);
        }
        return Optional.empty();
    }

    @Override
    public int getCardinality(Node node) {
        Optional<Block.Extremity> extremity = this.getExtremity(node);
        return extremity.map(this::getCardinality).orElse(0);
    }

    @Override
    public int getCardinality(Block.Extremity extremity) {
        return this.cardinality.get((Object)extremity);
    }

    @Override
    public void setCardinality(Block.Extremity extremity, int i) {
        this.cardinality.put(extremity, i);
    }

    public Block getParentBlock() {
        return this.parentBlock;
    }

    @Override
    public void setParentBlock(Block parentBlock) {
        this.parentBlock = parentBlock;
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    public void setOrientation(Orientation orientation) {
        this.getPosition().setOrientation(orientation);
    }

    @Override
    public void setOrientation(Orientation orientation, boolean recursively) {
        this.setOrientation(orientation);
    }

    @Override
    public Orientation getOrientation() {
        return this.getPosition().getOrientation();
    }

    @Override
    public Coord getCoord() {
        return this.coord;
    }

    @Override
    public Block.Type getType() {
        return this.type;
    }

    protected abstract void writeJsonContent(JsonGenerator var1, boolean var2) throws IOException;

    @Override
    public void writeJson(JsonGenerator generator, boolean includeCoordinates) throws IOException {
        generator.writeStartObject();
        generator.writeStringField("type", this.type.name());
        generator.writeArrayFieldStart("cardinalities");
        for (Map.Entry<Block.Extremity, Integer> ex : this.cardinality.entrySet()) {
            generator.writeStartObject();
            generator.writeObjectField(ex.getKey().name(), (Object)ex.getValue());
            generator.writeEndObject();
        }
        generator.writeEndArray();
        generator.writeFieldName("position");
        this.position.writeJsonContent(generator, includeCoordinates);
        if (includeCoordinates) {
            generator.writeFieldName("coord");
            this.coord.writeJsonContent(generator);
        }
        this.writeJsonContent(generator, includeCoordinates);
        generator.writeEndObject();
    }
}

