/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.model.blocks;

import com.fasterxml.jackson.core.JsonGenerator;
import com.powsybl.sld.model.blocks.AbstractBlock;
import com.powsybl.sld.model.blocks.Block;
import com.powsybl.sld.model.blocks.ComposedBlock;
import com.powsybl.sld.model.coordinate.Orientation;
import com.powsybl.sld.model.coordinate.Position;
import com.powsybl.sld.model.nodes.Node;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractComposedBlock
extends AbstractBlock
implements ComposedBlock {
    List<Block> subBlocks;

    AbstractComposedBlock(Block.Type type, List<Block> subBlocks) {
        super(type);
        if (subBlocks.isEmpty()) {
            throw new IllegalArgumentException("Empty block list");
        }
        subBlocks.forEach(b -> b.setParentBlock(this));
    }

    @Override
    public List<Block> getSubBlocks() {
        return this.subBlocks;
    }

    @Override
    public boolean isEmbeddingNodeType(Node.NodeType type) {
        return this.subBlocks.stream().anyMatch(b -> b.isEmbeddingNodeType(type));
    }

    @Override
    public List<Block> findBlockEmbeddingNode(Node node) {
        return this.subBlocks.stream().flatMap(b -> b.findBlockEmbeddingNode(node).stream()).collect(Collectors.toList());
    }

    @Override
    public Node getExtremityNode(Block.Extremity extremity) {
        if (extremity == Block.Extremity.START) {
            return this.subBlocks.get(0).getExtremityNode(Block.Extremity.START);
        }
        return this.subBlocks.get(this.subBlocks.size() - 1).getExtremityNode(Block.Extremity.END);
    }

    @Override
    public void reverseBlock() {
        Collections.reverse(this.subBlocks);
        this.subBlocks.forEach(Block::reverseBlock);
    }

    @Override
    public void setOrientation(Orientation orientation) {
        super.setOrientation(orientation);
        this.setOrientation(orientation, true);
    }

    @Override
    public void setOrientation(Orientation orientation, boolean recursively) {
        super.setOrientation(orientation);
        if (recursively) {
            this.subBlocks.forEach(sub -> sub.setOrientation(orientation));
        }
    }

    public Stream<Position.Segment> getSegments(Position.Dimension dimension) {
        return this.subBlocks.stream().map(b -> b.getPosition().getSegment(dimension));
    }

    @Override
    protected void writeJsonContent(JsonGenerator generator, boolean includeCoordinates) throws IOException {
        generator.writeFieldName("subBlocks");
        generator.writeStartArray();
        for (Block subBlock : this.subBlocks) {
            subBlock.writeJson(generator, includeCoordinates);
        }
        generator.writeEndArray();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.subBlocks;
    }
}

