/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.model.blocks;

import com.powsybl.sld.model.blocks.AbstractComposedBlock;
import com.powsybl.sld.model.blocks.Block;
import com.powsybl.sld.model.blocks.ComposedBlock;
import com.powsybl.sld.model.nodes.Node;
import java.util.ArrayList;
import java.util.List;

abstract class AbstractParallelBlock
extends AbstractComposedBlock {
    AbstractParallelBlock(Block.Type type, List<Block> subBlocks, boolean allowMerge) {
        super(type, subBlocks);
        this.subBlocks = new ArrayList();
        for (Block child : subBlocks) {
            if (child.getType().isParallel() && allowMerge) {
                this.subBlocks.addAll(((ComposedBlock)child).getSubBlocks());
                continue;
            }
            this.subBlocks.add(child);
        }
        Node node0s = subBlocks.get(0).getExtremityNode(Block.Extremity.START);
        Node node0e = subBlocks.get(0).getExtremityNode(Block.Extremity.END);
        for (Block b : this.subBlocks) {
            b.setParentBlock(this);
            if (b.getExtremityNode(Block.Extremity.START) == node0s || b.getExtremityNode(Block.Extremity.END) == node0e) continue;
            b.reverseBlock();
        }
        this.setCardinality(Block.Extremity.START, this.subBlocks.stream().mapToInt(c -> c.getType().isParallel() ? c.getCardinality(Block.Extremity.START) : 1).sum());
        this.setCardinality(Block.Extremity.END, this.subBlocks.stream().mapToInt(c -> c.getType().isParallel() ? c.getCardinality(Block.Extremity.END) : 1).sum());
    }
}

