/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.model.blocks;

import com.fasterxml.jackson.core.JsonGenerator;
import com.powsybl.commons.PowsyblException;
import com.powsybl.sld.model.blocks.AbstractBlock;
import com.powsybl.sld.model.blocks.Block;
import com.powsybl.sld.model.blocks.PrimaryBlock;
import com.powsybl.sld.model.coordinate.Orientation;
import com.powsybl.sld.model.nodes.BusNode;
import com.powsybl.sld.model.nodes.Node;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractPrimaryBlock
extends AbstractBlock
implements PrimaryBlock {
    protected final List<Node> nodes;

    protected AbstractPrimaryBlock(Block.Type type, List<Node> nodes) {
        super(type);
        if (nodes.isEmpty()) {
            throw new PowsyblException("Empty node list");
        }
        this.nodes = new ArrayList<Node>(nodes);
        this.setCardinality(Block.Extremity.START, 1);
        this.setCardinality(Block.Extremity.END, 1);
    }

    @Override
    public boolean isEmbeddingNodeType(Node.NodeType type) {
        return this.nodes.stream().anyMatch(n -> n.getType() == type);
    }

    @Override
    public List<Block> findBlockEmbeddingNode(Node node) {
        ArrayList<Block> result = new ArrayList<Block>();
        if (this.nodes.contains(node)) {
            result.add(this);
        }
        return result;
    }

    @Override
    public List<Node> getNodes() {
        return new ArrayList<Node>(this.nodes);
    }

    @Override
    public void reverseBlock() {
        Collections.reverse(this.nodes);
    }

    @Override
    public Node getExtremityNode(Block.Extremity extremity) {
        if (extremity == Block.Extremity.START) {
            return this.nodes.get(0);
        }
        if (extremity == Block.Extremity.END) {
            return this.nodes.get(this.nodes.size() - 1);
        }
        return null;
    }

    @Override
    public void setOrientation(Orientation orientation) {
        super.setOrientation(orientation);
        this.setOrientation(orientation, true);
    }

    @Override
    public void setOrientation(Orientation orientation, boolean recursively) {
        super.setOrientation(orientation);
        if (recursively) {
            this.nodes.stream().filter(n -> !(n instanceof BusNode)).forEach(n -> n.setOrientationFromBlock(orientation, this.nodes));
        }
    }

    @Override
    protected void writeJsonContent(JsonGenerator generator, boolean includeCoordinates) throws IOException {
        generator.writeFieldName("nodes");
        generator.writeStartArray();
        for (int i = 1; i <= this.nodes.size(); ++i) {
            generator.writeString(this.nodes.get(i - 1).getId());
        }
        generator.writeEndArray();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.nodes;
    }
}

