/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.model.blocks;

import com.powsybl.sld.model.blocks.AbstractParallelBlock;
import com.powsybl.sld.model.blocks.Block;
import com.powsybl.sld.model.blocks.BlockVisitor;
import com.powsybl.sld.model.coordinate.Position;
import java.util.Comparator;
import java.util.List;

public class BodyParallelBlock
extends AbstractParallelBlock {
    public BodyParallelBlock(List<Block> subBlocks, boolean allowMerge) {
        super(Block.Type.BODYPARALLEL, subBlocks, allowMerge);
    }

    @Override
    public void sizing() {
        this.subBlocks.forEach(Block::sizing);
        if (this.getPosition().getOrientation().isVertical()) {
            this.getPosition().getSegment(Position.Dimension.V).mergeEnvelop(this.getSegments(Position.Dimension.V));
            this.subBlocks.sort(Comparator.comparingInt(Block::getOrder));
            this.getPosition().getSegment(Position.Dimension.H).glue(this.getSegments(Position.Dimension.H));
        } else {
            this.getPosition().getSegment(Position.Dimension.H).mergeEnvelop(this.getSegments(Position.Dimension.H));
            this.getPosition().getSegment(Position.Dimension.V).glue(this.getSegments(Position.Dimension.V));
        }
    }

    @Override
    public void accept(BlockVisitor blockVisitor) {
        blockVisitor.visit(this);
    }
}

