/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.model.blocks;

import com.powsybl.sld.model.blocks.AbstractPrimaryBlock;
import com.powsybl.sld.model.blocks.Block;
import com.powsybl.sld.model.blocks.BlockVisitor;
import com.powsybl.sld.model.coordinate.Orientation;
import com.powsybl.sld.model.coordinate.Position;
import com.powsybl.sld.model.nodes.Node;
import java.util.List;

public final class BodyPrimaryBlock
extends AbstractPrimaryBlock {
    private BodyPrimaryBlock(List<Node> nodes) {
        super(Block.Type.BODYPRIMARY, nodes);
    }

    public static BodyPrimaryBlock createBodyPrimaryBlockInBusCell(List<Node> nodes) {
        return new BodyPrimaryBlock(nodes);
    }

    public static BodyPrimaryBlock createBodyPrimaryBlockForShuntCell(List<Node> nodes) {
        BodyPrimaryBlock bpy = new BodyPrimaryBlock(nodes);
        bpy.setOrientation(Orientation.RIGHT);
        return bpy;
    }

    @Override
    public void sizing() {
        if (this.getPosition().getOrientation().isVertical()) {
            this.getPosition().setSpan(Position.Dimension.H, 2);
            this.getPosition().setSpan(Position.Dimension.V, 2 * (this.nodes.size() - 1));
        } else {
            this.getPosition().setSpan(Position.Dimension.H, Math.max(2, 2 * (this.nodes.size() - 2)));
            this.getPosition().setSpan(Position.Dimension.V, 2);
        }
    }

    @Override
    public void accept(BlockVisitor blockVisitor) {
        blockVisitor.visit(this);
    }
}

