/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.model.blocks;

import com.powsybl.sld.model.blocks.AbstractPrimaryBlock;
import com.powsybl.sld.model.blocks.Block;
import com.powsybl.sld.model.blocks.BlockVisitor;
import com.powsybl.sld.model.coordinate.Position;
import com.powsybl.sld.model.nodes.FeederNode;
import com.powsybl.sld.model.nodes.Node;
import java.util.List;

public final class FeederPrimaryBlock
extends AbstractPrimaryBlock {
    public FeederPrimaryBlock(List<Node> nodes) {
        super(Block.Type.FEEDERPRIMARY, nodes);
        if (this.getExtremityNode(Block.Extremity.START).getType() == Node.NodeType.FEEDER) {
            super.reverseBlock();
        }
    }

    public FeederNode getFeederNode() {
        return (FeederNode)this.nodes.get(1);
    }

    public Node getConnectedNode() {
        return (Node)this.nodes.get(0);
    }

    @Override
    public void reverseBlock() {
    }

    @Override
    public void sizing() {
        this.getPosition().setSpan(Position.Dimension.H, 2);
        this.getPosition().setSpan(Position.Dimension.V, 0);
    }

    @Override
    public void accept(BlockVisitor blockVisitor) {
        blockVisitor.visit(this);
    }

    @Override
    public int getOrder() {
        return this.getFeederNode().getOrder().orElse(-1);
    }
}

