/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.model.blocks;

import com.powsybl.sld.model.blocks.AbstractParallelBlock;
import com.powsybl.sld.model.blocks.Block;
import com.powsybl.sld.model.blocks.BlockVisitor;
import com.powsybl.sld.model.blocks.LegBlock;
import com.powsybl.sld.model.blocks.LegPrimaryBlock;
import com.powsybl.sld.model.coordinate.Position;
import com.powsybl.sld.model.nodes.BusNode;
import java.util.List;
import java.util.stream.Collectors;

public class LegParallelBlock
extends AbstractParallelBlock
implements LegBlock {
    public LegParallelBlock(List<Block> subBlocks, boolean allowMerge) {
        super(Block.Type.LEGPARALLEL, subBlocks, allowMerge);
    }

    @Override
    public List<BusNode> getBusNodes() {
        return this.subBlocks.stream().map(b -> ((LegPrimaryBlock)b).getBusNode()).collect(Collectors.toList());
    }

    @Override
    public void sizing() {
        this.subBlocks.forEach(Block::sizing);
        if (this.getPosition().getOrientation().isVertical()) {
            this.getPosition().setSpan(Position.Dimension.V, 0);
            List subBlocksCopy = this.subBlocks.stream().map(LegPrimaryBlock.class::cast).collect(Collectors.toList());
            int h = 0;
            while (!subBlocksCopy.isEmpty()) {
                LegPrimaryBlock b = (LegPrimaryBlock)subBlocksCopy.get(0);
                Position pos = b.getPosition();
                pos.set(Position.Dimension.H, h);
                pos.set(Position.Dimension.V, 0);
                if (b.getStackableBlocks().isEmpty()) {
                    h += b.getPosition().getSpan(Position.Dimension.H);
                } else {
                    int finalH = h;
                    b.getStackableBlocks().forEach(sb -> {
                        Position position = sb.getPosition();
                        position.set(Position.Dimension.H, finalH);
                        position.set(Position.Dimension.V, 0);
                    });
                    h += b.getPosition().getSpan(Position.Dimension.H);
                    subBlocksCopy.removeAll(b.getStackableBlocks());
                }
                subBlocksCopy.remove(b);
            }
            this.getPosition().setSpan(Position.Dimension.H, h);
        }
    }

    @Override
    public void accept(BlockVisitor blockVisitor) {
        blockVisitor.visit(this);
    }
}

