/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.model.blocks;

import com.powsybl.sld.model.blocks.AbstractPrimaryBlock;
import com.powsybl.sld.model.blocks.Block;
import com.powsybl.sld.model.blocks.BlockVisitor;
import com.powsybl.sld.model.blocks.LegBlock;
import com.powsybl.sld.model.coordinate.Position;
import com.powsybl.sld.model.nodes.BusNode;
import com.powsybl.sld.model.nodes.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class LegPrimaryBlock
extends AbstractPrimaryBlock
implements LegBlock {
    private final List<LegPrimaryBlock> stackableBlocks = new ArrayList<LegPrimaryBlock>();

    public LegPrimaryBlock(List<Node> nodes) {
        super(Block.Type.LEGPRIMARY, nodes);
        if (this.getExtremityNode(Block.Extremity.END).getType() == Node.NodeType.BUS) {
            super.reverseBlock();
        }
    }

    public BusNode getBusNode() {
        return (BusNode)this.getExtremityNode(Block.Extremity.START);
    }

    @Override
    public List<BusNode> getBusNodes() {
        return Collections.singletonList(this.getBusNode());
    }

    public Node getNodeOnBus() {
        return (Node)this.nodes.get(1);
    }

    public void addStackableBlock(LegPrimaryBlock block) {
        this.stackableBlocks.add(block);
    }

    public List<LegPrimaryBlock> getStackableBlocks() {
        return new ArrayList<LegPrimaryBlock>(this.stackableBlocks);
    }

    @Override
    public void reverseBlock() {
    }

    @Override
    public void sizing() {
        if (this.getOrientation().isHorizontal()) {
            this.getPosition().setSpan(Position.Dimension.H, 0);
            this.getPosition().setSpan(Position.Dimension.V, 0);
        } else {
            this.getPosition().setSpan(Position.Dimension.H, 2);
            this.getPosition().setSpan(Position.Dimension.V, 0);
        }
    }

    @Override
    public void accept(BlockVisitor blockVisitor) {
        blockVisitor.visit(this);
    }
}

