/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.model.blocks;

import com.powsybl.commons.PowsyblException;
import com.powsybl.sld.model.blocks.AbstractComposedBlock;
import com.powsybl.sld.model.blocks.Block;
import com.powsybl.sld.model.blocks.BlockVisitor;
import com.powsybl.sld.model.coordinate.Position;
import com.powsybl.sld.model.graphs.VoltageLevelGraph;
import com.powsybl.sld.model.nodes.BusNode;
import com.powsybl.sld.model.nodes.FeederNode;
import com.powsybl.sld.model.nodes.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class SerialBlock
extends AbstractComposedBlock {
    public SerialBlock(List<Block> blocks) {
        super(Block.Type.SERIAL, blocks);
        this.subBlocks = blocks.size() == 1 && blocks.get(0).getType() == Block.Type.SERIAL ? ((SerialBlock)blocks.get(0)).getSubBlocks() : new ArrayList<Block>(blocks);
        this.postConstruct();
    }

    public SerialBlock(Block block) {
        this(Collections.singletonList(block));
    }

    @Override
    public int getOrder() {
        return this.getExtremityNode(Block.Extremity.END).getType() == Node.NodeType.FEEDER ? ((FeederNode)this.getExtremityNode(Block.Extremity.END)).getOrder().orElse(-1) : 0;
    }

    @Override
    public void accept(BlockVisitor blockVisitor) {
        blockVisitor.visit(this);
    }

    private void postConstruct() {
        if (this.subBlocks.size() != 1) {
            for (int i = 0; i < this.subBlocks.size() - 1; ++i) {
                this.alignChaining((Block)this.subBlocks.get(i), (Block)this.subBlocks.get(i + 1));
            }
            if (this.getLowerBlock().isEmbeddingNodeType(Node.NodeType.FEEDER) || this.getUpperBlock().isEmbeddingNodeType(Node.NodeType.BUS)) {
                this.reverseBlock();
            }
        }
        this.setCardinality(Block.Extremity.START, this.getLowerBlock().getCardinality(Block.Extremity.START));
        this.setCardinality(Block.Extremity.END, this.getUpperBlock().getCardinality(Block.Extremity.END));
    }

    private void alignChaining(Block block1, Block block2) {
        if (block1.getExtremityNode(Block.Extremity.END) == block2.getExtremityNode(Block.Extremity.START)) {
            return;
        }
        if (block1.getExtremityNode(Block.Extremity.END) == block2.getExtremityNode(Block.Extremity.END)) {
            block2.reverseBlock();
            return;
        }
        if (block1.getExtremityNode(Block.Extremity.START) == block2.getExtremityNode(Block.Extremity.END)) {
            block1.reverseBlock();
            block2.reverseBlock();
            return;
        }
        if (block1.getExtremityNode(Block.Extremity.START) == block2.getExtremityNode(Block.Extremity.START)) {
            block1.reverseBlock();
            return;
        }
        throw new PowsyblException("unconsistent chaining in SerialBlock");
    }

    public boolean addSubBlock(VoltageLevelGraph vlGraph, Block block) {
        for (Block.Extremity myExtremity : Block.Extremity.values()) {
            Node extremityNode = this.getExtremityNode(myExtremity);
            if (extremityNode instanceof FeederNode || extremityNode instanceof BusNode) continue;
            for (Block.Extremity itsExtremity : Block.Extremity.values()) {
                if (extremityNode != block.getExtremityNode(itsExtremity) || extremityNode.getCardinality(vlGraph) != this.getCardinality(extremityNode) + block.getCardinality(itsExtremity)) continue;
                this.insertBlock(block, myExtremity);
                return true;
            }
        }
        return false;
    }

    public Optional<Block.Extremity> whichExtremity(Block block) {
        if (block.equals(this.subBlocks.get(0))) {
            return Optional.of(Block.Extremity.START);
        }
        if (block.equals(this.subBlocks.get(this.subBlocks.size() - 1))) {
            return Optional.of(Block.Extremity.END);
        }
        return Optional.empty();
    }

    public Block extractBody(Collection<Block> blocks) {
        ArrayList<Block> subBlocksCopy = new ArrayList<Block>(this.subBlocks);
        subBlocksCopy.removeAll(blocks);
        if (subBlocksCopy.size() == 1) {
            return (Block)subBlocksCopy.get(0);
        }
        return new SerialBlock(subBlocksCopy);
    }

    private void insertBlock(Block block, Block.Extremity myExtremity) {
        block.setParentBlock(this);
        if (myExtremity == Block.Extremity.START) {
            this.subBlocks.add(0, block);
        } else {
            this.subBlocks.add(block);
        }
        this.postConstruct();
    }

    public Block getUpperBlock() {
        return (Block)this.subBlocks.get(this.subBlocks.size() - 1);
    }

    public Block getLowerBlock() {
        return (Block)this.subBlocks.get(0);
    }

    public List<Node> getChainingNodes() {
        ArrayList<Node> result = new ArrayList<Node>();
        for (int i = 0; i < this.subBlocks.size() - 1; ++i) {
            result.add(((Block)this.subBlocks.get(i)).getEndingNode());
        }
        return result;
    }

    @Override
    public void sizing() {
        this.subBlocks.forEach(Block::sizing);
        if (this.getPosition().getOrientation().isVertical()) {
            this.getPosition().getSegment(Position.Dimension.H).mergeEnvelop(this.getSegments(Position.Dimension.H));
            this.getPosition().getSegment(Position.Dimension.V).glue(this.getSegments(Position.Dimension.V));
        } else {
            this.getPosition().getSegment(Position.Dimension.V).mergeEnvelop(this.getSegments(Position.Dimension.V));
            this.getPosition().getSegment(Position.Dimension.H).glue(this.getSegments(Position.Dimension.H));
        }
    }
}

