/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.model.cells;

import com.fasterxml.jackson.core.JsonGenerator;
import com.powsybl.sld.model.blocks.Block;
import com.powsybl.sld.model.blocks.FeederPrimaryBlock;
import com.powsybl.sld.model.blocks.LegPrimaryBlock;
import com.powsybl.sld.model.cells.AbstractCell;
import com.powsybl.sld.model.cells.BusCell;
import com.powsybl.sld.model.cells.Cell;
import com.powsybl.sld.model.coordinate.Direction;
import com.powsybl.sld.model.nodes.BusNode;
import com.powsybl.sld.model.nodes.FeederNode;
import com.powsybl.sld.model.nodes.Node;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class AbstractBusCell
extends AbstractCell
implements BusCell {
    private final List<LegPrimaryBlock> legPrimaryBlocks = new ArrayList<LegPrimaryBlock>();
    private final List<FeederPrimaryBlock> feederPrimaryBlocks = new ArrayList<FeederPrimaryBlock>();
    private Integer order = null;
    private Direction direction = Direction.UNDEFINED;

    protected AbstractBusCell(int cellIndex, Cell.CellType type, Collection<Node> nodes) {
        super(cellIndex, type, nodes);
    }

    @Override
    public void blocksSetting(Block rootBlock, List<LegPrimaryBlock> primaryBlocksConnectedToBus, List<FeederPrimaryBlock> feederPrimaryBlocks) {
        this.setRootBlock(rootBlock);
        this.legPrimaryBlocks.addAll(primaryBlocksConnectedToBus);
        this.feederPrimaryBlocks.addAll(feederPrimaryBlocks);
    }

    @Override
    public List<BusNode> getBusNodes() {
        return this.nodes.stream().filter(n -> n.getType() == Node.NodeType.BUS).map(BusNode.class::cast).collect(Collectors.toList());
    }

    @Override
    public List<FeederNode> getFeederNodes() {
        return this.nodes.stream().filter(n -> n.getType() == Node.NodeType.FEEDER).map(FeederNode.class::cast).collect(Collectors.toList());
    }

    @Override
    public List<Node> getInternalAdjacentNodes(Node node) {
        return node.getAdjacentNodes().stream().filter(this.nodes::contains).collect(Collectors.toList());
    }

    @Override
    public List<LegPrimaryBlock> getLegPrimaryBlocks() {
        return Collections.unmodifiableList(this.legPrimaryBlocks);
    }

    @Override
    public List<FeederPrimaryBlock> getFeederPrimaryBlocks() {
        return Collections.unmodifiableList(this.feederPrimaryBlocks);
    }

    @Override
    public Optional<Integer> getOrder() {
        return Optional.ofNullable(this.order);
    }

    @Override
    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public void removeOrder() {
        this.order = null;
    }

    @Override
    public Direction getDirection() {
        return this.direction;
    }

    @Override
    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    @Override
    protected void writeJsonContent(JsonGenerator generator, boolean includeCoordinates) throws IOException {
        super.writeJsonContent(generator, includeCoordinates);
        if (includeCoordinates) {
            generator.writeStringField("direction", this.getDirection().name());
            if (this.order != null) {
                generator.writeNumberField("order", this.order.intValue());
            }
        }
    }

    @Override
    public String toString() {
        return this.getType() + " " + this.direction + " " + this.nodes;
    }
}

