/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.model.cells;

import com.fasterxml.jackson.core.JsonGenerator;
import com.powsybl.sld.model.blocks.Block;
import com.powsybl.sld.model.cells.Cell;
import com.powsybl.sld.model.nodes.Node;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public abstract class AbstractCell
implements Cell {
    private Cell.CellType type;
    private int number;
    protected final List<Node> nodes = new ArrayList<Node>();
    private Block rootBlock;

    AbstractCell(int cellNumber, Cell.CellType type, Collection<Node> nodes) {
        this.type = Objects.requireNonNull(type);
        this.number = cellNumber;
        this.setNodes(nodes);
    }

    @Override
    public List<Node> getNodes() {
        return new ArrayList<Node>(this.nodes);
    }

    private void setNodes(Collection<Node> nodes) {
        this.nodes.addAll(nodes);
    }

    @Override
    public void setType(Cell.CellType type) {
        this.type = type;
    }

    @Override
    public Cell.CellType getType() {
        return this.type;
    }

    @Override
    public Block getRootBlock() {
        return this.rootBlock;
    }

    @Override
    public void setRootBlock(Block rootBlock) {
        this.rootBlock = rootBlock;
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    protected void writeJsonContent(JsonGenerator generator, boolean includeCoordinates) throws IOException {
        generator.writeStringField("type", this.type.name());
        generator.writeNumberField("number", this.number);
    }

    @Override
    public void writeJson(JsonGenerator generator, boolean includeCoordinates) throws IOException {
        generator.writeStartObject();
        this.writeJsonContent(generator, includeCoordinates);
        if (this.rootBlock != null) {
            generator.writeFieldName("rootBlock");
            this.rootBlock.writeJson(generator, includeCoordinates);
        }
        generator.writeEndObject();
    }

    @Override
    public String getId() {
        return this.type + " " + this.number;
    }

    @Override
    public String getFullId() {
        return this.type + this.nodes.stream().map(Node::getId).sorted().collect(Collectors.toList()).toString();
    }

    public String toString() {
        return this.type + " " + this.nodes;
    }
}

