/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.model.cells;

import com.powsybl.commons.PowsyblException;
import com.powsybl.sld.model.cells.AbstractBusCell;
import com.powsybl.sld.model.cells.Cell;
import com.powsybl.sld.model.cells.CellVisitor;
import com.powsybl.sld.model.cells.ShuntCell;
import com.powsybl.sld.model.coordinate.Direction;
import com.powsybl.sld.model.coordinate.Position;
import com.powsybl.sld.model.coordinate.Side;
import com.powsybl.sld.model.nodes.FeederNode;
import com.powsybl.sld.model.nodes.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ExternCell
extends AbstractBusCell {
    private final List<ShuntCell> shuntCells = new ArrayList<ShuntCell>();

    public ExternCell(int cellNumber, Collection<Node> nodes, List<ShuntCell> shuntCells) {
        super(cellNumber, Cell.CellType.EXTERN, nodes);
        shuntCells.forEach(this::addShuntCell);
    }

    public void organizeBlockDirections() {
        this.getRootBlock().setOrientation(this.getDirection().toOrientation());
    }

    @Override
    public void accept(CellVisitor cellVisitor) {
        cellVisitor.visit(this);
    }

    @Override
    public int newHPosition(int hPosition) {
        int minHv = this.shuntCells.stream().filter(shuntCell -> shuntCell.getSideCell(Side.RIGHT) == this).mapToInt(shuntCell -> Math.max(hPosition, shuntCell.getSidePosition(Side.LEFT).get(Position.Dimension.H) + shuntCell.getSidePosition(Side.LEFT).getSpan(Position.Dimension.H) + shuntCell.getHSpan())).max().orElse(hPosition);
        Position pos = this.getRootBlock().getPosition();
        pos.set(Position.Dimension.H, minHv);
        pos.set(Position.Dimension.V, 0);
        return minHv + pos.getSpan(Position.Dimension.H);
    }

    public boolean isShunted() {
        return !this.shuntCells.isEmpty();
    }

    public List<ShuntCell> getShuntCells() {
        return this.shuntCells;
    }

    public void addShuntCell(ShuntCell shuntCell) {
        List<Node> shuntNodes = shuntCell.getNodes();
        if (this.getNodes().contains(shuntNodes.get(0))) {
            shuntCell.putSideCell(Side.LEFT, this);
        } else if (this.getNodes().contains(shuntNodes.get(shuntNodes.size() - 1))) {
            shuntCell.putSideCell(Side.RIGHT, this);
        } else {
            throw new PowsyblException("ShuntCell list of nodes incoherent with the connected externCells");
        }
        this.shuntCells.add(shuntCell);
    }

    @Override
    public String toString() {
        return this.getType() + " " + this.getOrder() + " " + this.getDirection() + " " + this.nodes;
    }

    @Override
    public void setDirection(Direction direction) {
        super.setDirection(direction);
        this.getNodes().stream().filter(f -> f.getType() == Node.NodeType.FEEDER).map(FeederNode.class::cast).forEach(fn -> {
            if (fn.getOrientation() == null || !fn.getOrientation().isHorizontal()) {
                fn.setDirection(direction);
            }
        });
    }
}

