/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.model.cells;

import com.powsybl.commons.PowsyblException;
import com.powsybl.sld.model.blocks.Block;
import com.powsybl.sld.model.blocks.LegBlock;
import com.powsybl.sld.model.blocks.LegParallelBlock;
import com.powsybl.sld.model.blocks.SerialBlock;
import com.powsybl.sld.model.cells.AbstractBusCell;
import com.powsybl.sld.model.cells.Cell;
import com.powsybl.sld.model.cells.CellVisitor;
import com.powsybl.sld.model.coordinate.Direction;
import com.powsybl.sld.model.coordinate.Orientation;
import com.powsybl.sld.model.coordinate.Position;
import com.powsybl.sld.model.coordinate.Side;
import com.powsybl.sld.model.nodes.BusNode;
import com.powsybl.sld.model.nodes.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternCell
extends AbstractBusCell {
    private static final Logger LOGGER = LoggerFactory.getLogger(InternCell.class);
    private static final Side BODY_SIDE = Side.LEFT;
    private Shape shape;
    private final Map<Side, LegBlock> legs = new EnumMap<Side, LegBlock>(Side.class);
    private Block body;
    private final boolean exceptionIfPatternNotHandled;

    public InternCell(int cellNumber, Collection<Node> nodes, boolean exceptionIfPatternNotHandled) {
        super(cellNumber, Cell.CellType.INTERN, nodes);
        this.setDirection(Direction.UNDEFINED);
        this.shape = Shape.UNDEFINED;
        this.exceptionIfPatternNotHandled = exceptionIfPatternNotHandled;
    }

    @Override
    public void accept(CellVisitor cellVisitor) {
        cellVisitor.visit(this);
    }

    public void organizeBlocks() {
        List<LegBlock> candidateLegs = this.searchLegs();
        if (this.getRootBlock().getType() == Block.Type.SERIAL && candidateLegs.size() == 2) {
            SerialBlock serialRootBlock = (SerialBlock)this.getRootBlock();
            this.assignLeg(serialRootBlock, candidateLegs.get(0));
            this.assignLeg(serialRootBlock, candidateLegs.get(1));
            this.body = serialRootBlock.extractBody(new ArrayList<Block>(this.legs.values()));
            this.body.setOrientation(Orientation.RIGHT);
            if (candidateLegs.stream().map(LegBlock::getBusNodes).allMatch(bn -> bn.size() == 1)) {
                this.shape = Shape.MAYBE_FLAT;
            }
        } else if (candidateLegs.size() == 1) {
            this.shape = Shape.ONE_LEG;
            LegBlock leg = candidateLegs.get(0);
            this.legs.put(Side.UNDEFINED, leg);
            leg.setOrientation(Orientation.UP);
        } else {
            if (this.exceptionIfPatternNotHandled) {
                throw new PowsyblException("InternCell pattern not recognized");
            }
            this.shape = Shape.UNHANDLED_PATTERN;
            LOGGER.error("InternCell pattern not handled");
            LegBlock leg = candidateLegs.get(0);
            this.legs.put(Side.UNDEFINED, candidateLegs.get(0));
            leg.setOrientation(Orientation.UP);
        }
    }

    public void setFlat() {
        this.shape = Shape.FLAT;
        this.setDirection(Direction.MIDDLE);
        this.legs.values().forEach(l -> l.setOrientation(Orientation.RIGHT));
    }

    private void assignLeg(SerialBlock sb, LegBlock candidateLeg) {
        Optional<Block.Extremity> extremity = sb.whichExtremity(candidateLeg);
        if (!extremity.isPresent()) {
            throw new PowsyblException("Unable to identify legs of internCell");
        }
        this.legs.put(this.extremityToSide(extremity.get()), candidateLeg);
        candidateLeg.setOrientation(Orientation.UP);
    }

    private Side extremityToSide(Block.Extremity extremity) {
        switch (extremity) {
            case START: {
                return Side.LEFT;
            }
            case END: {
                return Side.RIGHT;
            }
        }
        return Side.UNDEFINED;
    }

    private List<LegBlock> searchLegs() {
        return this.getLegPrimaryBlocks().stream().map(lpb -> lpb.getParentBlock() instanceof LegParallelBlock ? (LegParallelBlock)lpb.getParentBlock() : lpb).distinct().collect(Collectors.toList());
    }

    public boolean checkIsShape(Shape ... shape) {
        return this.shape.checkIsShape(shape);
    }

    public boolean checkIsNotShape(Shape ... shapes) {
        return this.shape.checkIsNotShape(shapes);
    }

    public void reverseCell() {
        this.body.reverseBlock();
        this.legs.computeIfPresent(Side.LEFT, (leftSide, leftLeg) -> {
            LegBlock rightLeg = this.legs.get((Object)Side.RIGHT);
            this.legs.put(Side.RIGHT, (LegBlock)leftLeg);
            return rightLeg;
        });
    }

    public int getSideHPos(Side side) {
        return this.getSideToLeg(side).getPosition().get(Position.Dimension.H);
    }

    @Override
    public void blockSizing() {
        this.legs.values().forEach(Block::sizing);
        if (this.shape.checkIsNotShape(Shape.ONE_LEG, Shape.UNDEFINED, Shape.UNHANDLED_PATTERN)) {
            this.body.sizing();
        }
    }

    @Override
    public int newHPosition(int hPosition) {
        int h = hPosition;
        if (this.shape == Shape.ONE_LEG) {
            this.legs.get((Object)Side.UNDEFINED).getPosition().set(Position.Dimension.H, h);
            h += this.legs.get((Object)Side.UNDEFINED).getPosition().getSpan(Position.Dimension.H);
        } else {
            this.legs.get((Object)Side.LEFT).getPosition().set(Position.Dimension.H, h);
            h += this.legs.get((Object)Side.LEFT).getPosition().getSpan(Position.Dimension.H);
            Position pos = this.body.getPosition();
            if (this.shape == Shape.FLAT) {
                pos.set(Position.Dimension.H, h);
                pos.set(Position.Dimension.V, this.legs.get((Object)Side.LEFT).getBusNodes().get(0).getBusbarIndex());
            } else {
                pos.set(Position.Dimension.H, h -= 2);
                pos.set(Position.Dimension.V, 0);
            }
            this.legs.get((Object)Side.RIGHT).getPosition().set(Position.Dimension.H, h += pos.getSpan(Position.Dimension.H));
            h += this.legs.get((Object)Side.RIGHT).getPosition().getSpan(Position.Dimension.H);
        }
        return h;
    }

    public int newHPosition(int hPosition, Side side) {
        int h = hPosition;
        if (side == Side.LEFT) {
            this.legs.get((Object)Side.LEFT).getPosition().set(Position.Dimension.H, h);
            h += this.legs.get((Object)Side.LEFT).getPosition().getSpan(Position.Dimension.H);
        }
        if (side == BODY_SIDE) {
            Position pos = this.body.getPosition();
            pos.set(Position.Dimension.H, h -= 2);
            pos.set(Position.Dimension.V, 1);
            h += this.body.getPosition().getSpan(Position.Dimension.H);
        }
        if (side == Side.RIGHT) {
            this.legs.get((Object)Side.RIGHT).getPosition().set(Position.Dimension.H, h);
            h += this.legs.get((Object)Side.RIGHT).getPosition().getSpan(Position.Dimension.H);
        }
        return h;
    }

    @Override
    public void setDirection(Direction direction) {
        super.setDirection(direction);
        for (LegBlock leg : this.legs.values()) {
            leg.setOrientation(direction.toOrientation());
        }
    }

    public Map<Side, LegBlock> getLegs() {
        return this.legs;
    }

    public LegBlock getSideToLeg(Side side) {
        return this.legs.get((Object)side);
    }

    public List<BusNode> getSideBusNodes(Side side) {
        return this.legs.get((Object)side).getBusNodes();
    }

    public Block getBodyBlock() {
        return this.body;
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public static enum Shape {
        UNDEFINED,
        UNHANDLED_PATTERN,
        MAYBE_FLAT,
        FLAT,
        CROSSOVER,
        VERTICAL,
        ONE_LEG;


        public boolean checkIsShape(Shape ... shapes) {
            return Arrays.stream(shapes).anyMatch(s -> s == this);
        }

        public boolean checkIsNotShape(Shape ... shapes) {
            return Arrays.stream(shapes).noneMatch(s -> s == this);
        }
    }
}

