/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.model.cells;

import com.powsybl.commons.PowsyblException;
import com.powsybl.sld.model.blocks.Block;
import com.powsybl.sld.model.blocks.BodyPrimaryBlock;
import com.powsybl.sld.model.cells.AbstractCell;
import com.powsybl.sld.model.cells.Cell;
import com.powsybl.sld.model.cells.CellVisitor;
import com.powsybl.sld.model.cells.ExternCell;
import com.powsybl.sld.model.coordinate.Direction;
import com.powsybl.sld.model.coordinate.Position;
import com.powsybl.sld.model.coordinate.Side;
import com.powsybl.sld.model.graphs.VoltageLevelGraph;
import com.powsybl.sld.model.nodes.BusNode;
import com.powsybl.sld.model.nodes.ConnectivityNode;
import com.powsybl.sld.model.nodes.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class ShuntCell
extends AbstractCell {
    private final Map<Side, ExternCell> sideCells = new EnumMap<Side, ExternCell>(Side.class);

    private ShuntCell(int cellNumber, List<Node> nodes) {
        super(cellNumber, Cell.CellType.SHUNT, nodes);
        if (!(nodes.get(0) instanceof ConnectivityNode) || !(nodes.get(nodes.size() - 1) instanceof ConnectivityNode)) {
            throw new PowsyblException("the first and last nodes of a shunt cell shall be ConnectivityNode");
        }
        ((ConnectivityNode)nodes.get(0)).setShunt(true);
        ((ConnectivityNode)nodes.get(nodes.size() - 1)).setShunt(true);
    }

    public static ShuntCell create(int cellNumber, List<Node> nodes, VoltageLevelGraph vlGraph) {
        ShuntCell shuntCell = new ShuntCell(cellNumber, nodes);
        vlGraph.addCell(shuntCell);
        return shuntCell;
    }

    @Override
    public void accept(CellVisitor cellVisitor) {
        cellVisitor.visit(this);
    }

    @Override
    public Direction getDirection() {
        return Direction.UNDEFINED;
    }

    @Override
    public BodyPrimaryBlock getRootBlock() {
        return (BodyPrimaryBlock)super.getRootBlock();
    }

    @Override
    public void setRootBlock(Block rootBlock) {
        if (!(rootBlock instanceof BodyPrimaryBlock)) {
            throw new PowsyblException("ShuntCell can only be composed of a single BodyPrimaryBlock");
        }
        super.setRootBlock(rootBlock);
    }

    public void putSideCell(Side side, ExternCell externCell) {
        this.sideCells.put(side, externCell);
    }

    public void alignExternCells() {
        if (this.sideCells.get((Object)Side.LEFT).getOrder().orElse(-1) > this.sideCells.get((Object)Side.RIGHT).getOrder().orElse(-1)) {
            this.reverse();
        }
    }

    public void alignDirections(Side side) {
        this.sideCells.get((Object)side.getFlip()).setDirection(this.sideCells.get((Object)side).getDirection());
    }

    private void reverse() {
        ExternCell cell = this.sideCells.get((Object)Side.LEFT);
        this.sideCells.put(Side.LEFT, this.sideCells.get((Object)Side.RIGHT));
        this.sideCells.put(Side.RIGHT, cell);
        Collections.reverse(this.nodes);
        this.getRootBlock().reverseBlock();
    }

    public ExternCell getSideCell(Side side) {
        return this.sideCells.get((Object)side);
    }

    public Node getSideShuntNode(Side side) {
        if (side == Side.UNDEFINED) {
            return null;
        }
        return side == Side.LEFT ? (Node)this.nodes.get(0) : (Node)this.nodes.get(this.nodes.size() - 1);
    }

    public Position getSidePosition(Side side) {
        return this.sideCells.get((Object)side).getRootBlock().getPosition();
    }

    public List<ExternCell> getSideCells() {
        return new ArrayList<ExternCell>(this.sideCells.values());
    }

    public int getHSpan() {
        return this.getRootBlock().getPosition().getSpan(Position.Dimension.H) - 4;
    }

    public List<BusNode> getParentBusNodes() {
        return this.getSideCells().stream().flatMap(c -> c.getBusNodes().stream()).collect(Collectors.toList());
    }

    @Override
    public String toString() {
        return "ShuntCell(" + this.nodes + " )";
    }
}

