/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.model.coordinate;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Coord {
    private Map<Dimension, Segment> dim2seg = new EnumMap<Dimension, Segment>(Dimension.class);

    public Coord(double x, double y) {
        this.dim2seg.put(Dimension.X, new Segment(x, 0.0, 0.0));
        this.dim2seg.put(Dimension.Y, new Segment(y, 0.0, 0.0));
    }

    public double get(Dimension dimension) {
        return this.dim2seg.get((Object)dimension).getValue();
    }

    public double getSpan(Dimension dimension) {
        return this.dim2seg.get((Object)dimension).getSpan();
    }

    public double getShift(Dimension dimension) {
        return this.dim2seg.get((Object)dimension).getShift();
    }

    public Segment getSegment(Dimension dimension) {
        return this.dim2seg.get((Object)dimension);
    }

    public void set(Dimension dimension, double value) {
        this.dim2seg.get((Object)dimension).setValue(value);
    }

    public void setSpan(Dimension dimension, double span) {
        this.dim2seg.get((Object)dimension).setSpan(span);
    }

    public void setShift(Dimension dimension, double shift) {
        this.dim2seg.get((Object)dimension).setShift(shift);
    }

    public String toString() {
        return "Coord(x=" + this.get(Dimension.X) + ", y=" + this.get(Dimension.Y) + ", xSpan=" + this.getSpan(Dimension.X) + ", ySpan=" + this.getSpan(Dimension.Y) + ")";
    }

    public void writeJsonContent(JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        generator.writeNumberField("x", this.get(Dimension.X));
        generator.writeNumberField("y", this.get(Dimension.Y));
        generator.writeNumberField("xSpan", this.getSpan(Dimension.X));
        generator.writeNumberField("ySpan", this.getSpan(Dimension.Y));
        generator.writeEndObject();
    }

    public static enum Dimension {
        X,
        Y;

    }

    public class Segment {
        private double value;
        private double span;
        private double shift;

        Segment(double value, double span, double shift) {
            this.value = value;
            this.span = span;
            this.shift = shift;
        }

        public void copy(Segment segment) {
            this.value = segment.value;
            this.span = segment.span;
            this.shift = segment.shift;
        }

        public void replicateMe(Stream<Segment> segments) {
            segments.forEach(seg -> seg.copy(this));
        }

        public double getValue() {
            return this.value;
        }

        public void setValue(double value) {
            this.value = value;
        }

        public double getSpan() {
            return this.span;
        }

        public void setSpan(double span) {
            this.span = span;
        }

        public double getShift() {
            return this.shift;
        }

        public void setShift(double shift) {
            this.shift = shift;
        }

        public void mergeEnvelop(Stream<Segment> segStream) {
            List<Segment> segments = segStream.collect(Collectors.toList());
            this.setSpan(segments.stream().mapToDouble(Segment::getSpan).max().orElse(0.0));
            segments.forEach(seg -> seg.setValue(0.0));
        }

        void glue(Stream<Segment> segStream) {
            List segments = segStream.collect(Collectors.toList());
            this.setSpan(segments.stream().mapToDouble(Segment::getSpan).sum());
            double cumulSpan = 0.0;
            for (Segment seg : segments) {
                seg.setValue(cumulSpan);
                cumulSpan += seg.getSpan();
            }
        }
    }
}

