/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.model.coordinate;

public enum Orientation {
    UP,
    DOWN,
    LEFT,
    RIGHT,
    MIDDLE,
    UNDEFINED;


    public boolean isVertical() {
        return this == UP || this == DOWN;
    }

    public boolean isHorizontal() {
        return this == LEFT || this == RIGHT;
    }

    public int progressionSign() {
        switch (this) {
            case UP: 
            case LEFT: {
                return -1;
            }
            case DOWN: 
            case RIGHT: {
                return 1;
            }
        }
        return 0;
    }

    public Orientation opposite() {
        switch (this) {
            case UP: {
                return DOWN;
            }
            case DOWN: {
                return UP;
            }
            case LEFT: {
                return RIGHT;
            }
            case RIGHT: {
                return LEFT;
            }
            case MIDDLE: {
                return MIDDLE;
            }
            case UNDEFINED: {
                return UNDEFINED;
            }
        }
        return null;
    }

    public double toRotationAngle() {
        switch (this) {
            case DOWN: {
                return 180.0;
            }
            case LEFT: {
                return 270.0;
            }
            case RIGHT: {
                return 90.0;
            }
        }
        return 0.0;
    }
}

