/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.model.coordinate;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Point {
    private double x;
    private double y;

    public Point(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Point(Point point) {
        this.x = point.x;
        this.y = point.y;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setCoordinates(Point point) {
        this.setX(point.x);
        this.setY(point.y);
    }

    public void setCoordinates(double x, double y) {
        this.setX(x);
        this.setY(y);
    }

    public static List<Point> createPointsList(double ... coordinates) {
        if (coordinates.length % 2 == 1) {
            throw new AssertionError((Object)"The number of coordinates given must be even");
        }
        ArrayList<Point> res = new ArrayList<Point>();
        for (int i = 0; i < coordinates.length / 2; ++i) {
            res.add(new Point(coordinates[2 * i], coordinates[2 * i + 1]));
        }
        return res;
    }

    public static List<Double> pointsToDoubles(List<Point> pol) {
        return pol.stream().flatMap(p -> Stream.of(p.getX(), p.getY())).collect(Collectors.toList());
    }

    public Point getMiddlePoint(Point other) {
        return new Point((this.x + other.x) / 2.0, (this.y + other.y) / 2.0);
    }

    public void shift(Point shiftPoint) {
        this.x += shiftPoint.x;
        this.y += shiftPoint.y;
    }

    public Point getShiftedPoint(Point shift) {
        Point res = new Point(this);
        res.shift(shift);
        return res;
    }

    public void shiftX(double transX) {
        this.x += transX;
    }

    public void shiftY(double transY) {
        this.y += transY;
    }

    public void scale(double scale) {
        this.x *= scale;
        this.y *= scale;
    }

    public double distanceSquare(Point other) {
        double dx = other.x - this.x;
        double dy = other.y - this.y;
        return dx * dx + dy * dy;
    }

    public double distance(Point other) {
        return Math.sqrt(this.distanceSquare(other));
    }

    public String toString() {
        return "{" + this.x + "," + this.y + "}";
    }
}

