/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.model.coordinate;

import com.fasterxml.jackson.core.JsonGenerator;
import com.powsybl.sld.model.coordinate.Orientation;
import java.io.IOException;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Position {
    private Map<Dimension, Segment> dim2Seg = new EnumMap<Dimension, Segment>(Dimension.class);
    private Orientation orientation;

    public Position(int h, int v, int hSpan, int vSpan, Orientation orientation) {
        this.dim2Seg.put(Dimension.H, new Segment(h, hSpan, 0));
        this.dim2Seg.put(Dimension.V, new Segment(v, vSpan, 0));
        this.orientation = orientation;
    }

    public Position(int h, int v) {
        this(h, v, 0, 0, Orientation.UNDEFINED);
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
    }

    public int get(Dimension dimension) {
        return this.dim2Seg.get((Object)dimension).getValue();
    }

    public int getSpan(Dimension dimension) {
        return this.dim2Seg.get((Object)dimension).getSpan();
    }

    public Position set(Dimension dimension, int h) {
        this.dim2Seg.get((Object)dimension).setValue(h);
        return this;
    }

    public Position setSpan(Dimension dimension, int h) {
        this.dim2Seg.get((Object)dimension).setSpan(h);
        return this;
    }

    public Segment getSegment(Dimension dimension) {
        return this.dim2Seg.get((Object)dimension);
    }

    public String toString() {
        return "h=" + this.get(Dimension.H) + " v=" + this.get(Dimension.V) + " hSpan=" + this.getSpan(Dimension.H) + " vSpan=" + this.getSpan(Dimension.V) + ", " + this.orientation;
    }

    public void writeJsonContent(JsonGenerator generator, boolean writeOrientation) throws IOException {
        generator.writeStartObject();
        generator.writeNumberField("h", this.get(Dimension.H));
        generator.writeNumberField("v", this.get(Dimension.V));
        generator.writeNumberField("hSpan", this.getSpan(Dimension.H));
        generator.writeNumberField("vSpan", this.getSpan(Dimension.V));
        if (this.orientation != Orientation.UNDEFINED && writeOrientation) {
            generator.writeStringField("orientation", this.orientation.name());
        }
        generator.writeEndObject();
    }

    public static enum Dimension {
        H,
        V;

    }

    public class Segment {
        private int value;
        private int span;
        private int shift;

        Segment(int value, int span, int shift) {
            this.value = value;
            this.span = span;
            this.shift = shift;
        }

        public void copy(Segment segment) {
            this.value = segment.value;
            this.span = segment.span;
            this.shift = segment.shift;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public int getSpan() {
            return this.span;
        }

        public void setSpan(int span) {
            this.span = span;
        }

        public int getShift() {
            return this.shift;
        }

        public void setShift(int shift) {
            this.shift = shift;
        }

        public void mergeEnvelop(Stream<Segment> segStream) {
            List<Segment> segments = segStream.collect(Collectors.toList());
            this.setSpan(segments.stream().mapToInt(Segment::getSpan).max().orElse(0));
            segments.forEach(seg -> seg.setValue(0));
        }

        public void glue(Stream<Segment> segStream) {
            List segments = segStream.collect(Collectors.toList());
            this.setSpan(segments.stream().mapToInt(Segment::getSpan).sum());
            int cumulSpan = 0;
            for (Segment seg : segments) {
                seg.setValue(cumulSpan);
                cumulSpan += seg.getSpan();
            }
        }
    }
}

