/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.model.graphs;

import com.fasterxml.jackson.core.JsonGenerator;
import com.powsybl.sld.model.graphs.AbstractGraph;
import com.powsybl.sld.model.graphs.BaseGraph;
import com.powsybl.sld.model.graphs.Graph;
import com.powsybl.sld.model.nodes.BranchEdge;
import com.powsybl.sld.model.nodes.FeederNode;
import com.powsybl.sld.model.nodes.MiddleTwtNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractBaseGraph
extends AbstractGraph
implements BaseGraph {
    private static final String EDGE_PREFIX = "EDGE_";
    protected List<BranchEdge> twtEdges = new ArrayList<BranchEdge>();
    protected List<MiddleTwtNode> multiTermNodes = new ArrayList<MiddleTwtNode>();

    AbstractBaseGraph(Graph parentGraph) {
        super(parentGraph);
    }

    @Override
    public List<BranchEdge> getTwtEdges() {
        return new ArrayList<BranchEdge>(this.twtEdges);
    }

    @Override
    public List<MiddleTwtNode> getMultiTermNodes() {
        return this.multiTermNodes;
    }

    @Override
    public BranchEdge addTwtEdge(FeederNode legNode, MiddleTwtNode twtNode) {
        BranchEdge edge = new BranchEdge(EDGE_PREFIX + legNode.getId(), legNode, twtNode);
        twtNode.addAdjacentEdge(edge);
        this.twtEdges.add(edge);
        return edge;
    }

    @Override
    public void addMultiTermNode(MiddleTwtNode node) {
        this.multiTermNodes.add(node);
    }

    protected void writeBranchFields(JsonGenerator generator, boolean includeCoordinates) throws IOException {
        generator.writeArrayFieldStart("multitermNodes");
        for (MiddleTwtNode multitermNode : this.multiTermNodes) {
            multitermNode.writeJson(generator, includeCoordinates);
        }
        generator.writeEndArray();
        generator.writeArrayFieldStart("twtEdges");
        for (BranchEdge edge : this.twtEdges) {
            edge.writeJson(generator, includeCoordinates);
        }
        generator.writeEndArray();
        generator.writeArrayFieldStart("lineEdges");
        for (BranchEdge edge : this.getLineEdges()) {
            edge.writeJson(generator, includeCoordinates);
        }
        generator.writeEndArray();
    }
}

