/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.model.graphs;

import com.powsybl.sld.model.cells.Cell;
import com.powsybl.sld.model.coordinate.Direction;
import com.powsybl.sld.model.coordinate.Point;
import com.powsybl.sld.model.graphs.VoltageLevelGraph;
import com.powsybl.sld.model.graphs.VoltageLevelInfos;
import com.powsybl.sld.model.nodes.BranchEdge;
import com.powsybl.sld.model.nodes.Node;
import java.io.Writer;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public interface Graph {
    public String getId();

    public VoltageLevelGraph getVoltageLevel(String var1);

    public List<VoltageLevelGraph> getVoltageLevels();

    public Stream<VoltageLevelGraph> getVoltageLevelStream();

    public VoltageLevelGraph getVoltageLevelGraph(Node var1);

    public VoltageLevelInfos getVoltageLevelInfos(Node var1);

    public Point getShiftedPoint(Node var1);

    public Map<Node, VoltageLevelGraph> getNodeToVlGraph();

    public Optional<Cell> getCell(Node var1);

    public Direction getDirection(Node var1);

    public void addNode(VoltageLevelGraph var1, Node var2);

    public void removeNode(Node var1);

    public Stream<Node> getAllNodesStream();

    public BranchEdge addLineEdge(String var1, Node var2, Node var3);

    public List<BranchEdge> getLineEdges();

    public void setCoordinatesSerialized(boolean var1);

    public double getWidth();

    public double getHeight();

    public void writeJson(Path var1);

    public void writeJson(Writer var1);
}

