/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.model.graphs;

import com.fasterxml.jackson.core.JsonGenerator;
import com.powsybl.sld.model.graphs.AbstractBaseGraph;
import com.powsybl.sld.model.graphs.Graph;
import com.powsybl.sld.model.graphs.VoltageLevelGraph;
import com.powsybl.sld.model.nodes.BranchEdge;
import com.powsybl.sld.model.nodes.MiddleTwtNode;
import com.powsybl.sld.model.nodes.Node;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jgrapht.graph.Pseudograph;

public class SubstationGraph
extends AbstractBaseGraph {
    private String substationId;
    private final List<VoltageLevelGraph> voltageLevels = new ArrayList<VoltageLevelGraph>();
    private final Map<String, VoltageLevelGraph> voltageLevelsById = new HashMap<String, VoltageLevelGraph>();

    protected SubstationGraph(String id, Graph parentGraph) {
        super(parentGraph);
        this.substationId = Objects.requireNonNull(id);
    }

    public static SubstationGraph create(String id, Graph parentGraph) {
        Objects.requireNonNull(id);
        return new SubstationGraph(id, parentGraph);
    }

    public static SubstationGraph create(String id) {
        Objects.requireNonNull(id);
        return new SubstationGraph(id, null);
    }

    public void addVoltageLevel(VoltageLevelGraph node) {
        this.voltageLevels.add(node);
        this.voltageLevelsById.put(node.getId(), node);
    }

    @Override
    public VoltageLevelGraph getVoltageLevel(String voltageLevelId) {
        Objects.requireNonNull(voltageLevelId);
        return this.voltageLevelsById.get(voltageLevelId);
    }

    @Override
    public List<VoltageLevelGraph> getVoltageLevels() {
        return Collections.unmodifiableList(this.voltageLevels);
    }

    @Override
    public Stream<VoltageLevelGraph> getVoltageLevelStream() {
        return this.voltageLevels.stream();
    }

    @Override
    public Stream<Node> getAllNodesStream() {
        return this.voltageLevels.stream().flatMap(g -> g.getNodes().stream());
    }

    public List<BranchEdge> getEdges() {
        return Stream.concat(this.getLineEdges().stream(), this.twtEdges.stream()).collect(Collectors.toList());
    }

    public boolean graphAdjacents(VoltageLevelGraph g1, VoltageLevelGraph g2) {
        if (g1 == g2) {
            return true;
        }
        int nbNodes = this.voltageLevels.size();
        for (int i = 0; i < nbNodes - 1; ++i) {
            if (this.voltageLevels.get(i) != g1 || this.voltageLevels.get(i + 1) != g2) continue;
            return true;
        }
        return false;
    }

    public String getSubstationId() {
        return this.substationId;
    }

    public org.jgrapht.Graph<VoltageLevelGraph, Object> toJgrapht() {
        Pseudograph graph = new Pseudograph(Object.class);
        for (VoltageLevelGraph voltageLevelGraph : this.getVoltageLevels()) {
            graph.addVertex((Object)voltageLevelGraph);
        }
        for (MiddleTwtNode multiNode : this.getMultiTermNodes()) {
            List<Node> adjacentNodes = multiNode.getAdjacentNodes();
            graph.addEdge((Object)this.getVoltageLevelGraph(adjacentNodes.get(0)), (Object)this.getVoltageLevelGraph(adjacentNodes.get(1)));
            if (adjacentNodes.size() != 3) continue;
            graph.addEdge((Object)this.getVoltageLevelGraph(adjacentNodes.get(0)), (Object)this.getVoltageLevelGraph(adjacentNodes.get(2)));
            graph.addEdge((Object)this.getVoltageLevelGraph(adjacentNodes.get(1)), (Object)this.getVoltageLevelGraph(adjacentNodes.get(2)));
        }
        return graph;
    }

    @Override
    public String getId() {
        return this.getSubstationId();
    }

    @Override
    public void writeJson(JsonGenerator generator, boolean includeCoordinates) throws IOException {
        generator.writeStartObject();
        generator.writeStringField("substationId", this.substationId);
        generator.writeArrayFieldStart("voltageLevels");
        for (VoltageLevelGraph graph : this.voltageLevels) {
            graph.writeJson(generator, includeCoordinates);
        }
        generator.writeEndArray();
        this.writeBranchFields(generator, includeCoordinates);
        generator.writeEndObject();
    }
}

