/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.model.graphs;

import com.fasterxml.jackson.core.JsonGenerator;
import com.powsybl.commons.PowsyblException;
import com.powsybl.sld.model.cells.BusCell;
import com.powsybl.sld.model.cells.Cell;
import com.powsybl.sld.model.cells.ExternCell;
import com.powsybl.sld.model.cells.InternCell;
import com.powsybl.sld.model.cells.ShuntCell;
import com.powsybl.sld.model.coordinate.Direction;
import com.powsybl.sld.model.coordinate.Orientation;
import com.powsybl.sld.model.coordinate.Point;
import com.powsybl.sld.model.coordinate.Position;
import com.powsybl.sld.model.graphs.AbstractBaseGraph;
import com.powsybl.sld.model.graphs.Graph;
import com.powsybl.sld.model.graphs.NodeFactory;
import com.powsybl.sld.model.graphs.VoltageLevelInfos;
import com.powsybl.sld.model.nodes.AbstractNode;
import com.powsybl.sld.model.nodes.BusNode;
import com.powsybl.sld.model.nodes.ConnectivityNode;
import com.powsybl.sld.model.nodes.Edge;
import com.powsybl.sld.model.nodes.EquipmentNode;
import com.powsybl.sld.model.nodes.FeederNode;
import com.powsybl.sld.model.nodes.FeederType;
import com.powsybl.sld.model.nodes.Node;
import com.powsybl.sld.model.nodes.SwitchNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jgrapht.graph.Pseudograph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VoltageLevelGraph
extends AbstractBaseGraph {
    private static final Logger LOGGER = LoggerFactory.getLogger(VoltageLevelGraph.class);
    private final VoltageLevelInfos voltageLevelInfos;
    private final List<Node> nodes = new ArrayList<Node>();
    private final List<Edge> edges = new ArrayList<Edge>();
    private final SortedSet<Cell> cells = new TreeSet<Cell>(Comparator.comparingInt(Cell::getNumber));
    private final Map<Node.NodeType, List<Node>> nodesByType = new EnumMap<Node.NodeType, List<Node>>(Node.NodeType.class);
    private final Map<String, Node> nodesById = new HashMap<String, Node>();
    private final Map<Node, Cell> nodeToCell = new HashMap<Node, Cell>();
    private int maxHorizontalBusPosition = 0;
    private int maxVerticalBusPosition = 0;
    private int cellCounter = 0;
    private final Point coord = new Point(0.0, 0.0);
    private final boolean forVoltageLevelDiagram;
    private Map<Direction, Double> maxCellHeight = new EnumMap<Direction, Double>(Direction.class);

    public VoltageLevelGraph(VoltageLevelInfos voltageLevelInfos, Graph parentGraph) {
        super(parentGraph);
        this.voltageLevelInfos = Objects.requireNonNull(voltageLevelInfos);
        this.forVoltageLevelDiagram = parentGraph == null;
    }

    @Override
    public String getId() {
        return this.voltageLevelInfos.getId();
    }

    public boolean isForVoltageLevelDiagram() {
        return this.forVoltageLevelDiagram;
    }

    public int getNextCellNumber() {
        return this.cellCounter++;
    }

    public void removeUnnecessaryConnectivityNodes() {
        List fictitiousNodesToRemove = this.nodes.stream().filter(ConnectivityNode.class::isInstance).collect(Collectors.toList());
        for (Node n : fictitiousNodesToRemove) {
            if (n.getAdjacentEdges().size() == 2) {
                List<Node> adjNodes = n.getAdjacentNodes();
                Node node1 = adjNodes.get(0);
                Node node2 = adjNodes.get(1);
                LOGGER.info("Remove fictitious node {} between {} and {}", new Object[]{n.getId(), node1.getId(), node2.getId()});
                this.removeNode(n);
                this.addEdge(node1, node2);
                continue;
            }
            LOGGER.info("Working on fictitious node {} with {} adjacent nodes", (Object)n.getId(), (Object)n.getAdjacentNodes().size());
            Node busNode = n.getAdjacentNodes().stream().filter(node -> node.getType() == Node.NodeType.BUS).findFirst().orElse(null);
            if (busNode != null) {
                n.getAdjacentNodes().stream().filter(node -> !node.equals(busNode)).forEach(node -> {
                    LOGGER.info("Connecting {} to {}", (Object)node.getId(), (Object)busNode.getId());
                    this.addEdge((Node)node, busNode);
                });
                LOGGER.info("Remove fictitious node {}", (Object)n.getId());
                this.removeNode(n);
                continue;
            }
            LOGGER.warn("Cannot remove fictitious node {} because there are no adjacent BUS nodes", (Object)n.getId());
        }
    }

    public void removeFictitiousSwitchNode() {
        List fictitiousSwitchNodesToRemove = this.getNodes().stream().filter(SwitchNode.class::isInstance).map(SwitchNode.class::cast).filter(AbstractNode::isFictitious).filter(node -> node.getAdjacentNodes().size() == 2).collect(Collectors.toList());
        for (SwitchNode n : fictitiousSwitchNodesToRemove) {
            Node node1 = n.getAdjacentNodes().get(0);
            Node node2 = n.getAdjacentNodes().get(1);
            LOGGER.info("Remove fictitious switch node {} between {} and {}", new Object[]{n.getName(), node1.getId(), node2.getId()});
            this.removeNode(n);
            this.addEdge(node1, node2);
        }
    }

    public void logCellDetectionStatus() {
        HashSet<Cell> cellsLog = new HashSet<Cell>();
        EnumMap<Cell.CellType, Integer> cellCountByType = new EnumMap<Cell.CellType, Integer>(Cell.CellType.class);
        for (Cell.CellType cellType : Cell.CellType.values()) {
            cellCountByType.put(cellType, 0);
        }
        int remainingNodeCount = 0;
        EnumMap<Node.NodeType, Integer> remainingNodeCountByType = new EnumMap<Node.NodeType, Integer>(Node.NodeType.class);
        for (Node.NodeType nodeType : Node.NodeType.values()) {
            remainingNodeCountByType.put(nodeType, 0);
        }
        for (Node node : this.nodes) {
            Optional<Cell> oCell = this.getCell(node);
            if (oCell.isPresent()) {
                Cell cell = oCell.get();
                if (!cellsLog.add(cell)) continue;
                cellCountByType.put(cell.getType(), (Integer)cellCountByType.get((Object)cell.getType()) + 1);
                continue;
            }
            ++remainingNodeCount;
            remainingNodeCountByType.put(node.getType(), (Integer)remainingNodeCountByType.get((Object)node.getType()) + 1);
        }
        if (cellsLog.isEmpty()) {
            LOGGER.warn("No cell detected");
        } else {
            LOGGER.info("{} cells detected ({})", (Object)cellsLog.size(), cellCountByType);
        }
        if (remainingNodeCount > 0) {
            LOGGER.warn("{}/{} nodes not associated to a cell ({})", new Object[]{remainingNodeCount, this.nodes.size(), remainingNodeCountByType});
        }
    }

    public org.jgrapht.Graph<Node, Edge> toJgrapht() {
        Pseudograph graph = new Pseudograph(Edge.class);
        for (Node node : this.nodes) {
            graph.addVertex((Object)node);
        }
        for (Edge edge : this.edges) {
            graph.addEdge((Object)edge.getNode1(), (Object)edge.getNode2(), (Object)edge);
        }
        return graph;
    }

    public void addNode(Node node) {
        if (this.nodes.contains(node)) {
            throw new AssertionError((Object)"The node cannot be added, it is already in the graph");
        }
        super.addNode(this, node);
        this.nodes.add(node);
        this.nodesByType.computeIfAbsent(node.getType(), nodeType -> new ArrayList()).add(node);
        this.nodesById.put(node.getId(), node);
    }

    @Override
    public void removeNode(Node node) {
        this.nodes.remove(node);
        super.removeNode(node);
        this.nodesByType.computeIfAbsent(node.getType(), nodeType -> new ArrayList()).remove(node);
        this.nodesById.remove(node.getId(), node);
        for (Edge edge : new ArrayList<Edge>(node.getAdjacentEdges())) {
            this.removeEdge(edge);
        }
    }

    public Node getNode(String id) {
        Objects.requireNonNull(id);
        return this.nodesById.get(id);
    }

    @Override
    public VoltageLevelGraph getVoltageLevel(String voltageLevelId) {
        Objects.requireNonNull(voltageLevelId);
        return voltageLevelId.equals(this.voltageLevelInfos.getId()) ? this : null;
    }

    @Override
    public List<VoltageLevelGraph> getVoltageLevels() {
        return Collections.singletonList(this);
    }

    @Override
    public Stream<VoltageLevelGraph> getVoltageLevelStream() {
        return Stream.of(this);
    }

    @Override
    public Stream<Node> getAllNodesStream() {
        return this.nodes.stream();
    }

    public Edge addEdge(Node n1, Node n2) {
        Edge edge = new Edge(n1, n2);
        this.edges.add(edge);
        n1.addAdjacentEdge(edge);
        n2.addAdjacentEdge(edge);
        return edge;
    }

    private Edge removeEdge(Node n1, Node n2) {
        for (Edge edge : n1.getAdjacentEdges()) {
            if (!edge.getNode1().equals(n2) && !edge.getNode2().equals(n2)) continue;
            this.removeEdge(edge);
            return edge;
        }
        throw new PowsyblException("Cannot remove edge, the two node are not connected");
    }

    private void removeEdge(Edge edge) {
        edge.getNode1().removeAdjacentEdge(edge);
        edge.getNode2().removeAdjacentEdge(edge);
        this.edges.remove(edge);
    }

    private void rIdentifyConnexComponent(Node node, List<Node> nodesIn, List<Node> connexComponent) {
        if (!connexComponent.contains(node)) {
            connexComponent.add(node);
            node.getAdjacentNodes().stream().filter(nodesIn::contains).forEach(n -> this.rIdentifyConnexComponent((Node)n, nodesIn, connexComponent));
        }
    }

    public List<List<Node>> getConnexComponents(List<Node> nodesIn) {
        ArrayList<Node> nodesToHandle = new ArrayList<Node>(nodesIn);
        ArrayList<List<Node>> result = new ArrayList<List<Node>>();
        while (!nodesToHandle.isEmpty()) {
            Node n = (Node)nodesToHandle.get(0);
            ArrayList<Node> connexComponent = new ArrayList<Node>();
            this.rIdentifyConnexComponent(n, nodesIn, connexComponent);
            nodesToHandle.removeAll(connexComponent);
            result.add(connexComponent);
        }
        return result;
    }

    public void setMaxBusPosition() {
        ArrayList h = new ArrayList();
        ArrayList v = new ArrayList();
        this.getNodeBuses().forEach(nodeBus -> {
            v.add(nodeBus.getBusbarIndex());
            h.add(nodeBus.getSectionIndex());
        });
        if (h.isEmpty() || v.isEmpty()) {
            return;
        }
        this.setMaxHorizontalBusPosition((Integer)Collections.max(h));
        this.setMaxVerticalBusPosition((Integer)Collections.max(v));
    }

    public void insertBusConnections(Predicate<Node> nodesOnBus) {
        this.getNodeBuses().forEach(busNode -> this.insertBusConnections((BusNode)busNode, nodesOnBus));
    }

    private void insertBusConnections(BusNode busNode, Predicate<Node> nodesOnBus) {
        busNode.getAdjacentNodes().stream().filter(node -> !nodesOnBus.test((Node)node)).forEach(node -> this.insertBusConnection(busNode, (Node)node));
    }

    private void insertBusConnection(BusNode busNode, Node nodeConnectedToBusNode) {
        Node fNodeToBus = NodeFactory.createBusConnection(this, busNode.getId() + "_" + nodeConnectedToBusNode.getId());
        this.insertNode(busNode, fNodeToBus, nodeConnectedToBusNode);
    }

    private void insertNode(Node nodeA, Node nodeToInsert, Node nodeB) {
        Edge removedEdge = this.removeEdge(nodeA, nodeB);
        if (removedEdge.getNode1() == nodeA) {
            this.addEdge(nodeA, nodeToInsert);
            this.addEdge(nodeToInsert, nodeB);
        } else {
            this.addEdge(nodeB, nodeToInsert);
            this.addEdge(nodeToInsert, nodeA);
        }
    }

    public void insertHookNodesAtBuses() {
        this.getNodeBuses().forEach(this::insertHookNodesAtBuses);
    }

    private void insertHookNodesAtBuses(BusNode busNode) {
        busNode.getAdjacentNodes().forEach(nodeOnBus -> nodeOnBus.getAdjacentNodes().stream().filter(n -> n.getType() != Node.NodeType.BUS).filter(n -> n.getType() != Node.NodeType.INTERNAL || n instanceof EquipmentNode).forEach(n -> this.insertBusHookNode((Node)nodeOnBus, (Node)n)));
    }

    private void insertBusHookNode(Node nodeOnBus, Node node) {
        ConnectivityNode fStackNode = NodeFactory.createConnectivityNode(this, nodeOnBus.getId() + "-" + node.getId());
        if (node.getType() == Node.NodeType.FEEDER) {
            this.transferEdges(node, fStackNode);
            this.addEdge(fStackNode, node);
        } else {
            this.insertNode(nodeOnBus, fStackNode, node);
        }
    }

    public void insertHookNodesAtFeeders() {
        List feederNodes = this.nodesByType.computeIfAbsent(Node.NodeType.FEEDER, nodeType -> new ArrayList());
        feederNodes.stream().filter(feederNode -> !this.isInternal3wtFeederNode((FeederNode)feederNode)).forEach(this::insertFeederHookNode);
    }

    private boolean isInternal3wtFeederNode(FeederNode feederNode) {
        return feederNode.getFeeder().getFeederType() == FeederType.THREE_WINDINGS_TRANSFORMER_LEG && feederNode.getAdjacentNodes().get(0).getComponentType().equals("THREE_WINDINGS_TRANSFORMER");
    }

    private void insertFeederHookNode(Node feederNode) {
        ConnectivityNode hookNode = NodeFactory.createConnectivityNode(this, feederNode.getId());
        List<Node> adjacentNodes = feederNode.getAdjacentNodes();
        if (adjacentNodes.size() == 1) {
            Node singleNeighbor = adjacentNodes.get(0);
            this.insertNode(singleNeighbor, hookNode, feederNode);
        } else {
            ConnectivityNode forkNode = NodeFactory.createConnectivityNode(this, feederNode.getId() + "_fork");
            this.transferEdges(feederNode, forkNode);
            this.addEdge(forkNode, hookNode);
            this.addEdge(hookNode, feederNode);
        }
    }

    public void extendBusesConnectedToBuses() {
        this.getNodeBuses().forEach(n1 -> n1.getAdjacentNodes().stream().filter(BusNode.class::isInstance).forEach(n2 -> this.extendBusConnectedToBus((BusNode)n1, (BusNode)n2)));
    }

    private void extendBusConnectedToBus(BusNode n1, BusNode n2) {
        this.removeEdge(n1, n2);
        String busToBusId = n1.getId() + "-" + n2.getId();
        ConnectivityNode cNode1 = NodeFactory.createConnectivityNode(this, busToBusId + "_1");
        ConnectivityNode cNode2 = NodeFactory.createConnectivityNode(this, busToBusId + "_2");
        this.addEdge(n1, cNode1);
        this.addEdge(cNode1, cNode2);
        this.addEdge(n2, cNode2);
    }

    public ConnectivityNode insertConnectivityNode(Node node1, Node node2, String id) {
        ConnectivityNode iNode = NodeFactory.createConnectivityNode(this, id);
        this.insertNode(node1, iNode, node2);
        return iNode;
    }

    public void substituteNode(Node nodeOrigin, Node newNode) {
        this.transferEdges(nodeOrigin, newNode);
        this.removeNode(nodeOrigin);
    }

    private void transferEdges(Node nodeOrigin, Node newNode) {
        if (!this.nodesById.containsKey(newNode.getId())) {
            throw new PowsyblException("New node [" + newNode.getId() + "] is not in current voltage level graph");
        }
        for (Edge edge : new ArrayList<Edge>(nodeOrigin.getAdjacentEdges())) {
            Node node1 = edge.getNode1() == nodeOrigin ? newNode : edge.getNode1();
            Node node2 = edge.getNode2() == nodeOrigin ? newNode : edge.getNode2();
            this.addEdge(node1, node2);
            this.removeEdge(edge);
        }
    }

    public void substituteFictitiousNodesMirroringBusNodes() {
        this.getNodeBuses().forEach(busNode -> {
            List<Node> adjs = busNode.getAdjacentNodes();
            if (adjs.size() == 1 && adjs.get(0).getType() == Node.NodeType.INTERNAL) {
                Node adj = adjs.get(0);
                this.removeEdge(adj, (Node)busNode);
                this.substituteNode(adj, (Node)busNode);
            }
        });
    }

    public void substituteSingularFictitiousByFeederNode() {
        this.getNodes().stream().filter(n -> n.getType() == Node.NodeType.INTERNAL && n.getAdjacentEdges().size() == 1).forEach(n -> this.substituteNode((Node)n, NodeFactory.createFictitiousFeederNode(this, n.getId(), Orientation.UP)));
    }

    public void addCell(Cell c) {
        this.cells.add(c);
        List<Node> cellNodes = c.getNodes();
        if (c.getType() == Cell.CellType.SHUNT) {
            cellNodes.stream().skip(1L).limit((long)cellNodes.size() - 2L).forEach(n -> this.nodeToCell.put((Node)n, c));
        } else {
            cellNodes.stream().filter(n -> n.getType() != Node.NodeType.BUS).forEach(n -> this.nodeToCell.put((Node)n, c));
        }
    }

    public void removeCell(Cell c) {
        this.cells.remove(c);
        c.getNodes().forEach(n -> this.nodeToCell.remove(n, c));
    }

    public List<BusNode> getNodeBuses() {
        return this.nodesByType.computeIfAbsent(Node.NodeType.BUS, nodeType -> new ArrayList()).stream().map(BusNode.class::cast).collect(Collectors.toList());
    }

    public List<FeederNode> getFeederNodes() {
        return this.nodesByType.computeIfAbsent(Node.NodeType.FEEDER, nodeType -> new ArrayList()).stream().map(FeederNode.class::cast).collect(Collectors.toList());
    }

    public List<Node> getNodes() {
        return new ArrayList<Node>(this.nodes);
    }

    public Stream<ConnectivityNode> getConnectivityNodeStream() {
        return this.nodesByType.computeIfAbsent(Node.NodeType.INTERNAL, nodeType -> new ArrayList()).stream().filter(ConnectivityNode.class::isInstance).map(ConnectivityNode.class::cast);
    }

    public List<Edge> getEdges() {
        return new ArrayList<Edge>(this.edges);
    }

    public Set<Node> getNodeSet() {
        return new LinkedHashSet<Node>(this.nodes);
    }

    public Set<Edge> getEdgeSet() {
        return new LinkedHashSet<Edge>(this.edges);
    }

    public Stream<Cell> getCellStream() {
        return this.cells.stream();
    }

    public Stream<BusCell> getBusCellStream() {
        return this.cells.stream().filter(BusCell.class::isInstance).map(BusCell.class::cast);
    }

    public List<BusCell> getBusCells() {
        return this.getBusCellStream().collect(Collectors.toList());
    }

    public Stream<InternCell> getInternCellStream() {
        return this.cells.stream().filter(InternCell.class::isInstance).map(InternCell.class::cast);
    }

    public Stream<ExternCell> getExternCellStream() {
        return this.cells.stream().filter(ExternCell.class::isInstance).map(ExternCell.class::cast);
    }

    public Stream<ShuntCell> getShuntCellStream() {
        return this.cells.stream().filter(ShuntCell.class::isInstance).map(ShuntCell.class::cast);
    }

    @Override
    public Optional<Cell> getCell(Node node) {
        return Optional.ofNullable(this.nodeToCell.get(node));
    }

    public VoltageLevelInfos getVoltageLevelInfos() {
        return this.voltageLevelInfos;
    }

    public Point getCoord() {
        return this.coord;
    }

    public void setCoord(double x, double y) {
        this.coord.setX(x);
        this.coord.setY(y);
    }

    public double getX() {
        return this.coord.getX();
    }

    public double getY() {
        return this.coord.getY();
    }

    public boolean isPositionNodeBusesCalculated() {
        return this.getNodeBuses().stream().allMatch(n -> n.getPosition().get(Position.Dimension.H) != -1 && n.getPosition().get(Position.Dimension.V) != -1);
    }

    @Override
    public void writeJson(JsonGenerator generator, boolean includeCoordinates) throws IOException {
        generator.writeStartObject();
        generator.writeFieldName("voltageLevelInfos");
        this.voltageLevelInfos.writeJsonContent(generator);
        if (includeCoordinates) {
            generator.writeNumberField("x", this.getX());
            generator.writeNumberField("y", this.getY());
        }
        generator.writeArrayFieldStart("nodes");
        Iterator nodesIt = this.nodes.stream().sorted(Comparator.comparing(Node::getId)).iterator();
        while (nodesIt.hasNext()) {
            ((Node)nodesIt.next()).writeJson(generator, includeCoordinates);
        }
        generator.writeEndArray();
        generator.writeArrayFieldStart("cells");
        for (Cell cell : this.cells) {
            cell.writeJson(generator, includeCoordinates);
        }
        generator.writeEndArray();
        generator.writeArrayFieldStart("edges");
        for (Edge edge : this.edges) {
            edge.writeJson(generator);
        }
        generator.writeEndArray();
        this.writeBranchFields(generator, includeCoordinates);
        generator.writeEndObject();
    }

    public int getMaxH() {
        return this.getNodeBuses().stream().mapToInt(nodeBus -> nodeBus.getPosition().get(Position.Dimension.H) + nodeBus.getPosition().getSpan(Position.Dimension.H)).max().orElse(0);
    }

    public int getMaxV() {
        return this.getNodeBuses().stream().mapToInt(nodeBus -> nodeBus.getPosition().get(Position.Dimension.V) + nodeBus.getPosition().getSpan(Position.Dimension.V)).max().orElse(0);
    }

    public Double getExternCellHeight(Direction direction) {
        if (this.maxCellHeight.isEmpty() || direction == Direction.MIDDLE || direction == Direction.UNDEFINED) {
            return 0.0;
        }
        return this.maxCellHeight.get((Object)direction);
    }

    public void setMaxCellHeight(Map<Direction, Double> maxCellHeight) {
        this.maxCellHeight = maxCellHeight;
    }

    public int getMaxHorizontalBusPosition() {
        return this.maxHorizontalBusPosition;
    }

    public void setMaxHorizontalBusPosition(int maxHorizontalBusPosition) {
        this.maxHorizontalBusPosition = maxHorizontalBusPosition;
    }

    public int getMaxVerticalBusPosition() {
        return this.maxVerticalBusPosition;
    }

    public void setMaxVerticalBusPosition(int maxVerticalBusPosition) {
        this.maxVerticalBusPosition = maxVerticalBusPosition;
    }

    public double getFirstBusY() {
        return this.getExternCellHeight(Direction.TOP);
    }

    public double getLastBusY(double verticalSpaceBus) {
        return this.getFirstBusY() + (double)(this.getMaxVerticalBusPosition() - 1) * verticalSpaceBus;
    }

    public double getInnerHeight(double verticalSpaceBus) {
        return this.getExternCellHeight(Direction.TOP) + verticalSpaceBus * (double)this.getMaxV() + this.getExternCellHeight(Direction.BOTTOM);
    }
}

