/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.model.graphs;

import com.fasterxml.jackson.core.JsonGenerator;
import com.powsybl.sld.model.graphs.AbstractGraph;
import com.powsybl.sld.model.graphs.Graph;
import com.powsybl.sld.model.graphs.SubstationGraph;
import com.powsybl.sld.model.graphs.VoltageLevelGraph;
import com.powsybl.sld.model.nodes.BranchEdge;
import com.powsybl.sld.model.nodes.Node;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ZoneGraph
extends AbstractGraph {
    private final List<String> zone;
    private final List<SubstationGraph> substations = new ArrayList<SubstationGraph>();
    private final Map<String, SubstationGraph> substationsById = new HashMap<String, SubstationGraph>();
    private final Map<String, BranchEdge> edgesById = new HashMap<String, BranchEdge>();

    protected ZoneGraph(List<String> zone) {
        super(null);
        this.zone = Objects.requireNonNull(zone);
    }

    public static ZoneGraph create(List<String> zone) {
        return new ZoneGraph(zone);
    }

    @Override
    public String getId() {
        return String.join((CharSequence)"_", this.zone);
    }

    public void addSubstation(SubstationGraph sGraph) {
        this.substations.add(sGraph);
        this.substationsById.put(sGraph.getSubstationId(), sGraph);
    }

    @Override
    public BranchEdge addLineEdge(String lineId, Node node1, Node node2) {
        BranchEdge edge = super.addLineEdge(lineId, node1, node2);
        this.edgesById.put(lineId, edge);
        return edge;
    }

    public List<String> getZone() {
        return this.zone;
    }

    public List<SubstationGraph> getSubstations() {
        return this.substations;
    }

    @Override
    public VoltageLevelGraph getVoltageLevel(String voltageLevelId) {
        Objects.requireNonNull(voltageLevelId);
        return this.getVoltageLevelStream().filter(g -> voltageLevelId.equals(g.getVoltageLevelInfos().getId())).findFirst().orElse(null);
    }

    @Override
    public Stream<VoltageLevelGraph> getVoltageLevelStream() {
        return this.substations.stream().flatMap(SubstationGraph::getVoltageLevelStream);
    }

    @Override
    public List<VoltageLevelGraph> getVoltageLevels() {
        return this.getVoltageLevelStream().collect(Collectors.toList());
    }

    @Override
    public Stream<Node> getAllNodesStream() {
        return this.getVoltageLevelStream().flatMap(Graph::getAllNodesStream);
    }

    public SubstationGraph getSubstationGraph(String id) {
        Objects.requireNonNull(id);
        return this.substationsById.get(id);
    }

    public BranchEdge getLineEdge(String lineId) {
        Objects.requireNonNull(lineId);
        return this.edgesById.get(lineId);
    }

    @Override
    public void writeJson(JsonGenerator generator, boolean includeCoordinates) throws IOException {
        generator.writeStartObject();
        generator.writeArrayFieldStart("substations");
        for (SubstationGraph substationGraph : this.substations) {
            substationGraph.writeJson(generator, includeCoordinates);
        }
        generator.writeEndArray();
        generator.writeArrayFieldStart("lineEdges");
        for (BranchEdge edge : this.getLineEdges()) {
            edge.writeJson(generator, includeCoordinates);
        }
        generator.writeEndArray();
        generator.writeEndObject();
    }
}

