/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.model.nodes;

import com.fasterxml.jackson.core.JsonGenerator;
import com.powsybl.sld.model.coordinate.Direction;
import com.powsybl.sld.model.coordinate.Orientation;
import com.powsybl.sld.model.coordinate.Point;
import com.powsybl.sld.model.graphs.VoltageLevelGraph;
import com.powsybl.sld.model.nodes.BusNode;
import com.powsybl.sld.model.nodes.Edge;
import com.powsybl.sld.model.nodes.FeederNode;
import com.powsybl.sld.model.nodes.Node;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class AbstractNode
implements Node {
    private Node.NodeType type;
    private final String id;
    private final String componentType;
    private final boolean fictitious;
    private final Point position = new Point(-1.0, -1.0);
    private final List<Edge> adjacentEdges = new ArrayList<Edge>();
    private String label;
    private Integer order;
    private Direction direction = Direction.UNDEFINED;
    private Orientation orientation;

    protected AbstractNode(Node.NodeType type, String id, String componentType, boolean fictitious) {
        this.type = Objects.requireNonNull(type);
        this.id = Objects.requireNonNull(id);
        this.componentType = Objects.requireNonNull(componentType);
        this.fictitious = fictitious;
        this.setOrientation(this.defaultOrientation());
    }

    @Override
    public String getComponentType() {
        return this.componentType;
    }

    @Override
    public boolean isFictitious() {
        return this.fictitious;
    }

    @Override
    public void setType(Node.NodeType type) {
        this.type = type;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Optional<String> getLabel() {
        return Optional.ofNullable(this.label);
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public List<Node> getAdjacentNodes() {
        return this.adjacentEdges.stream().map(edge -> edge.getNode1() == this ? edge.getNode2() : edge.getNode1()).collect(Collectors.toList());
    }

    @Override
    public List<Edge> getAdjacentEdges() {
        return this.adjacentEdges;
    }

    @Override
    public void addAdjacentEdge(Edge e) {
        this.adjacentEdges.add(e);
    }

    @Override
    public void removeAdjacentEdge(Edge e) {
        this.adjacentEdges.remove(e);
    }

    @Override
    public Point getCoordinates() {
        return this.position;
    }

    @Override
    public void setCoordinates(Point coord) {
        this.position.setCoordinates(coord);
    }

    @Override
    public void setCoordinates(double x, double y) {
        this.position.setCoordinates(x, y);
    }

    @Override
    public double getX() {
        return this.position.getX();
    }

    @Override
    public double getY() {
        return this.position.getY();
    }

    @Override
    public void setX(double x) {
        this.position.setX(x);
    }

    @Override
    public void setY(double y) {
        this.position.setY(y);
    }

    @Override
    public Node.NodeType getType() {
        return this.type;
    }

    @Override
    public Optional<Integer> getOrder() {
        return Optional.ofNullable(this.order);
    }

    @Override
    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public void removeOrder() {
        this.order = null;
    }

    @Override
    public Direction getDirection() {
        return this.direction;
    }

    @Override
    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    @Override
    public Orientation getOrientation() {
        return this.orientation;
    }

    @Override
    public void setOrientation(Orientation orientation) {
        this.orientation = Objects.requireNonNullElse(orientation, this.defaultOrientation());
    }

    @Override
    public void setOrientationFromBlock(Orientation blockOrientation, List<Node> blockNodes) {
        this.setOrientation(blockOrientation);
    }

    protected Orientation defaultOrientation() {
        return Orientation.UP;
    }

    @Override
    public boolean checkNodeSimilarity(Node n) {
        return this.equals(n) || this.similarToAFeederNode(this) && this.similarToAFeederNode(n) || this instanceof BusNode && n instanceof BusNode;
    }

    @Override
    public boolean similarToAFeederNode(Node n) {
        return n instanceof FeederNode || n.getType() == Node.NodeType.INTERNAL && n.getAdjacentEdges().size() == 1;
    }

    @Override
    public int getCardinality(VoltageLevelGraph vlGraph) {
        return this.getAdjacentNodes().size();
    }

    protected void writeJsonContent(JsonGenerator generator, boolean includeCoordinates) throws IOException {
        generator.writeStringField("type", this.type.name());
        generator.writeStringField("id", this.id);
        generator.writeStringField("componentType", this.componentType);
        generator.writeBooleanField("fictitious", this.fictitious);
        if (includeCoordinates) {
            generator.writeNumberField("x", this.getX());
            generator.writeNumberField("y", this.getY());
        }
        if (this.orientation != this.defaultOrientation()) {
            generator.writeStringField("orientation", this.orientation.name());
        }
        if (this.label != null) {
            generator.writeStringField("label", this.label);
        }
    }

    @Override
    public void writeJson(JsonGenerator generator, boolean includeCoordinates) throws IOException {
        generator.writeStartObject();
        this.writeJsonContent(generator, includeCoordinates);
        generator.writeEndObject();
    }

    public String toString() {
        return this.type + " " + this.id;
    }
}

