/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.model.nodes;

import com.fasterxml.jackson.core.JsonGenerator;
import com.powsybl.sld.model.coordinate.Point;
import com.powsybl.sld.model.nodes.Edge;
import com.powsybl.sld.model.nodes.Node;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class BranchEdge
extends Edge {
    private final String id;
    private List<Point> snakeLine = new ArrayList<Point>();

    public BranchEdge(String id, Node node1, Node node2) {
        super(node1, node2);
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public List<Point> getSnakeLine() {
        return this.snakeLine;
    }

    public void setSnakeLine(List<Point> snakeLine) {
        this.snakeLine = Objects.requireNonNull(snakeLine);
    }

    @Override
    public void writeJson(JsonGenerator generator) throws IOException {
        this.writeJson(generator, false);
    }

    public void writeJson(JsonGenerator generator, boolean includeCoordinates) throws IOException {
        generator.writeStartObject();
        generator.writeStringField("id", this.id);
        generator.writeArrayFieldStart("nodes");
        super.writeJson(generator);
        generator.writeEndArray();
        if (includeCoordinates) {
            generator.writeArrayFieldStart("snakeLine");
            for (Point point : this.getSnakeLine()) {
                generator.writeNumber(point.getX());
                generator.writeNumber(point.getY());
            }
            generator.writeEndArray();
        }
        generator.writeEndObject();
    }
}

