/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.model.nodes;

import com.fasterxml.jackson.core.JsonGenerator;
import com.powsybl.sld.model.coordinate.Orientation;
import com.powsybl.sld.model.coordinate.Position;
import com.powsybl.sld.model.nodes.EquipmentNode;
import com.powsybl.sld.model.nodes.Node;
import java.io.IOException;

public class BusNode
extends EquipmentNode {
    private double pxWidth = 1.0;
    private int busbarIndex;
    private int sectionIndex;
    private Position position = new Position(-1, -1);

    public BusNode(String id, String name, boolean fictitious) {
        super(Node.NodeType.BUS, id, name, id, "BUSBAR_SECTION", fictitious);
    }

    @Override
    protected Orientation defaultOrientation() {
        return Orientation.RIGHT;
    }

    public double getPxWidth() {
        return this.pxWidth;
    }

    public void setPxWidth(double widthBus) {
        this.pxWidth = widthBus;
    }

    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public void setBusBarIndexSectionIndex(int busbarIndex, int sectionIndex) {
        this.busbarIndex = busbarIndex;
        this.sectionIndex = sectionIndex;
    }

    public int getBusbarIndex() {
        return this.busbarIndex;
    }

    public void setBusbarIndex(int busbarIndex) {
        this.busbarIndex = busbarIndex;
    }

    public int getSectionIndex() {
        return this.sectionIndex;
    }

    public void setSectionIndex(int sectionIndex) {
        this.sectionIndex = sectionIndex;
    }

    @Override
    protected void writeJsonContent(JsonGenerator generator, boolean includeCoordinates) throws IOException {
        super.writeJsonContent(generator, includeCoordinates);
        generator.writeNumberField("pxWidth", this.pxWidth);
        generator.writeNumberField("busbarIndex", this.busbarIndex);
        generator.writeNumberField("sectionIndex", this.sectionIndex);
        if (this.position != null) {
            generator.writeFieldName("position");
            this.position.writeJsonContent(generator, true);
        }
    }
}

