/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.model.nodes;

import com.fasterxml.jackson.core.JsonGenerator;
import com.powsybl.commons.PowsyblException;
import com.powsybl.sld.model.cells.Cell;
import com.powsybl.sld.model.graphs.VoltageLevelGraph;
import com.powsybl.sld.model.nodes.AbstractNode;
import com.powsybl.sld.model.nodes.Node;
import java.io.IOException;
import java.util.List;

public class ConnectivityNode
extends AbstractNode {
    private boolean isShunt = false;

    public ConnectivityNode(String id, String componentType) {
        super(Node.NodeType.INTERNAL, id, componentType, true);
    }

    public boolean isShunt() {
        return this.isShunt;
    }

    public void setShunt(boolean shunt) {
        if (this.getAdjacentNodes().size() < 3) {
            throw new PowsyblException("to be a shunt, a node must have 3+ adjacent nodes");
        }
        this.isShunt = shunt;
    }

    @Override
    public int getCardinality(VoltageLevelGraph vlGraph) {
        if (!this.isShunt) {
            return super.getCardinality(vlGraph);
        }
        List<Node> adjacentNodes = this.getAdjacentNodes();
        int nbAdjacentShuntCells = (int)adjacentNodes.stream().filter(n -> vlGraph.getCell((Node)n).map(c -> c.getType() == Cell.CellType.SHUNT).orElse(true)).count();
        return adjacentNodes.size() - nbAdjacentShuntCells;
    }

    @Override
    protected void writeJsonContent(JsonGenerator generator, boolean includeCoordinates) throws IOException {
        super.writeJsonContent(generator, includeCoordinates);
        if (this.isShunt) {
            generator.writeBooleanField("isShunt", true);
        }
    }
}

