/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.model.nodes;

import com.fasterxml.jackson.core.JsonGenerator;
import com.powsybl.sld.model.coordinate.Point;
import com.powsybl.sld.model.nodes.Node;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class Edge {
    private final List<Node> nodes;

    public Edge(Node node1, Node node2) {
        this.nodes = Arrays.asList(node1, node2);
    }

    public Node getNode(int index) {
        return this.nodes.get(index);
    }

    public Node getNode1() {
        return this.getNode(0);
    }

    public Node getNode2() {
        return this.getNode(1);
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public void writeJson(JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        for (int i = 1; i <= this.nodes.size(); ++i) {
            generator.writeStringField("node" + i, this.nodes.get(i - 1).getId());
        }
        generator.writeEndObject();
    }

    public boolean isZeroLength() {
        Point node1 = this.getNode1().getCoordinates();
        Point node2 = this.getNode2().getCoordinates();
        return node1.getX() == node2.getX() && node1.getY() == node2.getY();
    }
}

