/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.model.nodes;

import com.fasterxml.jackson.core.JsonGenerator;
import com.powsybl.sld.model.coordinate.Orientation;
import com.powsybl.sld.model.nodes.EquipmentNode;
import com.powsybl.sld.model.nodes.Feeder;
import com.powsybl.sld.model.nodes.Node;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;

public class FeederNode
extends EquipmentNode {
    private final Feeder feeder;

    public FeederNode(String id, String name, String equipmentId, String componentTypeName, boolean fictitious, Feeder feeder, Orientation orientation) {
        super(Node.NodeType.FEEDER, id, name, equipmentId, componentTypeName, fictitious);
        this.feeder = Objects.requireNonNull(feeder);
        this.setOrientation(orientation);
    }

    protected FeederNode(String id, String name, String equipmentId, String componentTypeName, Feeder feeder) {
        this(id, name, equipmentId, componentTypeName, false, feeder, null);
    }

    public Feeder getFeeder() {
        return this.feeder;
    }

    @Override
    protected void writeJsonContent(JsonGenerator generator, boolean includeCoordinates) throws IOException {
        super.writeJsonContent(generator, includeCoordinates);
        generator.writeStringField("feederType", this.feeder.getFeederType().name());
        Optional<Integer> order = this.getOrder();
        if (order.isPresent()) {
            generator.writeNumberField("order", order.get().intValue());
        }
        if (includeCoordinates) {
            generator.writeStringField("direction", this.getDirection().name());
        }
        this.getFeeder().writeJsonContent(generator);
    }
}

