/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.model.nodes;

import com.powsybl.sld.model.graphs.VoltageLevelInfos;
import com.powsybl.sld.model.nodes.Edge;
import com.powsybl.sld.model.nodes.MiddleTwtNode;
import com.powsybl.sld.model.nodes.Node;
import com.powsybl.sld.model.nodes.NodeSide;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;

public class Middle3WTNode
extends MiddleTwtNode {
    private final Map<Winding, NodeSide> windingMap = new EnumMap<Winding, NodeSide>(Winding.class);
    private final boolean embeddedInVlGraph;

    public Middle3WTNode(String id, String name, VoltageLevelInfos voltageLevelInfosLeg1, VoltageLevelInfos voltageLevelInfosLeg2, VoltageLevelInfos voltageLevelInfosLeg3, boolean embeddedInVLGraph) {
        super(id, name, new VoltageLevelInfos[]{Objects.requireNonNull(voltageLevelInfosLeg1), Objects.requireNonNull(voltageLevelInfosLeg2), Objects.requireNonNull(voltageLevelInfosLeg3)}, "THREE_WINDINGS_TRANSFORMER");
        this.embeddedInVlGraph = embeddedInVLGraph;
    }

    public boolean isEmbeddedInVlGraph() {
        return this.embeddedInVlGraph;
    }

    public void setWindingOrder(Winding first, Winding second, Winding third) {
        this.setWindingOrder(first, NodeSide.ONE);
        this.setWindingOrder(second, NodeSide.TWO);
        this.setWindingOrder(third, NodeSide.THREE);
    }

    public void setWindingOrder(Winding winding, NodeSide legSide) {
        this.windingMap.put(winding, legSide);
    }

    public Node getAdjacentNode(Winding winding) {
        Edge edge = this.getAdjacentEdges().get(this.windingToLegIndex(winding));
        return edge.getNode1() == this ? edge.getNode2() : edge.getNode1();
    }

    public VoltageLevelInfos getVoltageLevelInfos(Winding winding) {
        return this.voltageLevelInfosLeg[this.windingToLegIndex(winding)];
    }

    private int windingToLegIndex(Winding winding) {
        return this.windingMap.getOrDefault((Object)winding, NodeSide.ONE).getIntValue() - 1;
    }

    public static enum Winding {
        UPPER_LEFT,
        UPPER_RIGHT,
        DOWN;

    }
}

