/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.model.nodes;

import com.fasterxml.jackson.core.JsonGenerator;
import com.powsybl.commons.PowsyblException;
import com.powsybl.sld.model.coordinate.Direction;
import com.powsybl.sld.model.nodes.EquipmentNode;
import com.powsybl.sld.model.nodes.Node;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;

public class SwitchNode
extends EquipmentNode {
    private boolean open = false;
    private final SwitchKind kind;

    public SwitchNode(String id, String name, String componentType, boolean fictitious, SwitchKind kind, boolean open) {
        super(Node.NodeType.SWITCH, id, name, id, componentType, fictitious);
        this.kind = Objects.requireNonNull(kind);
        this.setOpen(open);
    }

    public SwitchKind getKind() {
        return this.kind;
    }

    public Node getOtherAdjNode(Node adj) {
        if (this.getAdjacentNodes().size() != 2) {
            throw new PowsyblException("Error switch node not having exactly 2 adjacent nodes " + this.getId());
        }
        return this.getAdjacentNodes().get(this.getAdjacentNodes().get(0).equals(adj) ? 1 : 0);
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    @Override
    protected void writeJsonContent(JsonGenerator generator, boolean includeCoordinates) throws IOException {
        super.writeJsonContent(generator, includeCoordinates);
        generator.writeBooleanField("open", this.open);
        generator.writeStringField("kind", this.kind.name());
        Optional<Integer> optOrder = this.getOrder();
        if (optOrder.isPresent()) {
            generator.writeNumberField("order", optOrder.get().intValue());
        }
        if (this.getDirection() != null && this.getDirection() != Direction.UNDEFINED) {
            generator.writeStringField("direction", this.getDirection().name());
        }
    }

    public static enum SwitchKind {
        BREAKER,
        DISCONNECTOR,
        LOAD_BREAK_SWITCH;

    }
}

