/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.svg;

import com.powsybl.diagram.util.ValueFormatter;
import com.powsybl.sld.layout.LayoutParameters;
import com.powsybl.sld.library.ComponentLibrary;
import com.powsybl.sld.model.coordinate.Direction;
import com.powsybl.sld.model.coordinate.Side;
import com.powsybl.sld.model.graphs.VoltageLevelGraph;
import com.powsybl.sld.model.nodes.BusNode;
import com.powsybl.sld.model.nodes.EquipmentNode;
import com.powsybl.sld.model.nodes.FeederNode;
import com.powsybl.sld.model.nodes.Middle3WTNode;
import com.powsybl.sld.model.nodes.Node;
import com.powsybl.sld.svg.BusInfo;
import com.powsybl.sld.svg.DiagramLabelProvider;
import com.powsybl.sld.svg.ElectricalNodeInfo;
import com.powsybl.sld.svg.LabelPosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public abstract class AbstractDiagramLabelProvider
implements DiagramLabelProvider {
    private static final double LABEL_OFFSET = 5.0;
    private static final double DECORATOR_OFFSET = 5.0;
    protected final ComponentLibrary componentLibrary;
    protected final LayoutParameters layoutParameters;
    protected final ValueFormatter valueFormatter;

    protected AbstractDiagramLabelProvider(ComponentLibrary componentLibrary, LayoutParameters layoutParameters) {
        this.componentLibrary = Objects.requireNonNull(componentLibrary);
        this.layoutParameters = Objects.requireNonNull(layoutParameters);
        this.valueFormatter = layoutParameters.createValueFormatter();
    }

    @Override
    public String getTooltip(Node node) {
        return node instanceof EquipmentNode ? ((EquipmentNode)node).getName() : null;
    }

    @Override
    public List<DiagramLabelProvider.NodeLabel> getNodeLabels(Node node, Direction direction) {
        Objects.requireNonNull(node);
        ArrayList<DiagramLabelProvider.NodeLabel> nodeLabels = new ArrayList<DiagramLabelProvider.NodeLabel>();
        if (node instanceof FeederNode) {
            this.getLabelOrNameOrId(node).ifPresent(label -> nodeLabels.add(new DiagramLabelProvider.NodeLabel((String)label, this.getFeederLabelPosition(node, direction), null)));
        } else if (node instanceof BusNode) {
            this.getLabelOrNameOrId(node).ifPresent(label -> nodeLabels.add(new DiagramLabelProvider.NodeLabel((String)label, this.getBusLabelPosition(), null)));
        }
        return nodeLabels;
    }

    private Optional<String> getLabelOrNameOrId(Node node) {
        if (node instanceof EquipmentNode) {
            EquipmentNode eqNode = (EquipmentNode)node;
            return Optional.ofNullable(node.getLabel().orElse(this.layoutParameters.isUseName() ? eqNode.getName() : eqNode.getEquipmentId()));
        }
        return node.getLabel();
    }

    protected LabelPosition getFeederDecoratorPosition(Direction direction, String componentType) {
        double yShift = -5.0;
        String positionName = "";
        if (direction != Direction.UNDEFINED) {
            yShift = (double)(-direction.toOrientation().progressionSign()) * this.layoutParameters.getFeederSpan();
            positionName = direction == Direction.TOP ? "N" : "S";
        }
        return new LabelPosition(positionName + "_DECORATOR", (int)(this.componentLibrary.getSize(componentType).getWidth() / 2.0 + 5.0), yShift, true, 0);
    }

    protected LabelPosition getMiddle3WTDecoratorPosition(Middle3WTNode node, Direction direction) {
        double yShift = -5.0;
        String positionName = "";
        if (direction != Direction.UNDEFINED) {
            int excessHeight3wt = 10;
            yShift = (double)direction.toOrientation().progressionSign() * (this.componentLibrary.getSize(node.getComponentType()).getHeight() - 1.5 * (double)excessHeight3wt + 5.0);
            positionName = direction == Direction.TOP ? "N" : "S";
        }
        return new LabelPosition(positionName + "_DECORATOR", 0.0, yShift, true, 0);
    }

    protected LabelPosition getFeederLabelPosition(Node node, Direction direction) {
        double yShift = -5.0;
        String positionName = "";
        double angle = 0.0;
        if (direction != Direction.UNDEFINED) {
            yShift = direction == Direction.TOP ? -5.0 : (double)((int)this.componentLibrary.getSize(node.getComponentType()).getHeight()) + 5.0;
            String string = positionName = direction == Direction.TOP ? "N" : "S";
            if (this.layoutParameters.isLabelDiagonal()) {
                angle = direction == Direction.TOP ? -this.layoutParameters.getAngleLabelShift() : this.layoutParameters.getAngleLabelShift();
            }
        }
        return new LabelPosition(positionName + "_LABEL", this.layoutParameters.isLabelCentered() ? 0.0 : -5.0, yShift, this.layoutParameters.isLabelCentered(), (int)angle);
    }

    protected LabelPosition getBusLabelPosition() {
        return new LabelPosition("NW_LABEL", -5.0, -5.0, false, 0);
    }

    @Override
    public List<ElectricalNodeInfo> getElectricalNodesInfos(VoltageLevelGraph graph) {
        return Collections.emptyList();
    }

    @Override
    public Optional<BusInfo> getBusInfo(BusNode node) {
        return Optional.empty();
    }

    @Override
    public Map<String, Side> getBusInfoSides(VoltageLevelGraph graph) {
        HashMap<String, Side> result = new HashMap<String, Side>();
        graph.getNodeBuses().forEach(busNode -> this.getBusInfo((BusNode)busNode).ifPresent(busInfo -> result.put(busNode.getId(), busInfo.getAnchor())));
        return result;
    }
}

