/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.sld.svg;

import com.powsybl.diagram.util.ValueFormatter;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.HvdcConverterStation;
import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.extensions.BranchStatus;
import com.powsybl.sld.layout.LayoutParameters;
import com.powsybl.sld.library.ComponentLibrary;
import com.powsybl.sld.model.coordinate.Direction;
import com.powsybl.sld.model.graphs.VoltageLevelGraph;
import com.powsybl.sld.model.nodes.EquipmentNode;
import com.powsybl.sld.model.nodes.Feeder;
import com.powsybl.sld.model.nodes.FeederNode;
import com.powsybl.sld.model.nodes.Middle3WTNode;
import com.powsybl.sld.model.nodes.MiddleTwtNode;
import com.powsybl.sld.model.nodes.Node;
import com.powsybl.sld.model.nodes.NodeSide;
import com.powsybl.sld.model.nodes.SwitchNode;
import com.powsybl.sld.model.nodes.feeders.FeederTwLeg;
import com.powsybl.sld.model.nodes.feeders.FeederWithSides;
import com.powsybl.sld.svg.AbstractDiagramLabelProvider;
import com.powsybl.sld.svg.DiagramLabelProvider;
import com.powsybl.sld.svg.DirectionalFeederInfo;
import com.powsybl.sld.svg.ElectricalNodeInfo;
import com.powsybl.sld.svg.FeederInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class DefaultDiagramLabelProvider
extends AbstractDiagramLabelProvider {
    private static final String PLANNED_OUTAGE_BRANCH_NODE_DECORATOR = "LOCK";
    private static final String FORCED_OUTAGE_BRANCH_NODE_DECORATOR = "FLASH";
    protected final Network network;

    public DefaultDiagramLabelProvider(Network net, ComponentLibrary componentLibrary, LayoutParameters layoutParameters) {
        super(componentLibrary, layoutParameters);
        this.network = Objects.requireNonNull(net);
    }

    @Override
    public List<FeederInfo> getFeederInfos(FeederNode node) {
        Objects.requireNonNull(node);
        List<Object> feederInfos = new ArrayList();
        Feeder feeder = node.getFeeder();
        switch (feeder.getFeederType()) {
            case INJECTION: {
                feederInfos = this.getInjectionFeederInfos(node);
                break;
            }
            case BRANCH: {
                feederInfos = this.getBranchFeederInfos(node, (FeederWithSides)feeder);
                break;
            }
            case TWO_WINDINGS_TRANSFORMER_LEG: {
                feederInfos = this.get2WTFeederInfos(node, (FeederTwLeg)feeder);
                break;
            }
            case THREE_WINDINGS_TRANSFORMER_LEG: {
                feederInfos = this.get3WTFeederInfos(node, (FeederTwLeg)feeder);
                break;
            }
            case HVDC: {
                feederInfos = this.getHvdcFeederInfos(node, (FeederWithSides)feeder);
                break;
            }
        }
        if (node.getDirection() == Direction.BOTTOM && !this.layoutParameters.isFeederInfoSymmetry()) {
            Collections.reverse(feederInfos);
        }
        return feederInfos;
    }

    private List<FeederInfo> getInjectionFeederInfos(FeederNode node) {
        List<FeederInfo> measures = new ArrayList<FeederInfo>();
        Injection injection = (Injection)this.network.getIdentifiable(node.getEquipmentId());
        if (injection != null) {
            measures = this.buildFeederInfos(injection);
        }
        return measures;
    }

    private List<FeederInfo> getBranchFeederInfos(FeederNode node, FeederWithSides feeder) {
        List<FeederInfo> measures = new ArrayList<FeederInfo>();
        Branch branch = this.network.getBranch(node.getEquipmentId());
        if (branch != null) {
            Branch.Side side = Branch.Side.valueOf((String)feeder.getSide().name());
            measures = this.buildFeederInfos(branch, side);
        }
        return measures;
    }

    private List<FeederInfo> get3WTFeederInfos(FeederNode node, FeederTwLeg feeder) {
        List<FeederInfo> feederInfos = new ArrayList<FeederInfo>();
        ThreeWindingsTransformer transformer = this.network.getThreeWindingsTransformer(node.getEquipmentId());
        if (transformer != null) {
            ThreeWindingsTransformer.Side side = ThreeWindingsTransformer.Side.valueOf((String)feeder.getSide().name());
            feederInfos = this.buildFeederInfos(transformer, side);
        }
        return feederInfos;
    }

    private List<FeederInfo> get2WTFeederInfos(FeederNode node, FeederTwLeg feeder) {
        List<FeederInfo> measures = new ArrayList<FeederInfo>();
        TwoWindingsTransformer transformer = this.network.getTwoWindingsTransformer(node.getEquipmentId());
        if (transformer != null) {
            Branch.Side side = Branch.Side.valueOf((String)feeder.getSide().name());
            measures = this.buildFeederInfos((Branch<?>)transformer, side);
        }
        return measures;
    }

    private List<FeederInfo> getHvdcFeederInfos(FeederNode node, FeederWithSides feeder) {
        List<FeederInfo> measures = new ArrayList<FeederInfo>();
        HvdcLine hvdcLine = this.network.getHvdcLine(node.getEquipmentId());
        if (hvdcLine != null) {
            NodeSide side = feeder.getSide();
            measures = this.buildFeederInfos(hvdcLine, side);
        }
        return measures;
    }

    @Override
    public List<DiagramLabelProvider.NodeDecorator> getNodeDecorators(Node node, Direction direction) {
        Objects.requireNonNull(node);
        ArrayList<DiagramLabelProvider.NodeDecorator> nodeDecorators = new ArrayList<DiagramLabelProvider.NodeDecorator>();
        if (node instanceof EquipmentNode && !(node instanceof SwitchNode)) {
            if (node instanceof FeederNode) {
                FeederNode feederNode = (FeederNode)node;
                switch (feederNode.getFeeder().getFeederType()) {
                    case BRANCH: 
                    case TWO_WINDINGS_TRANSFORMER_LEG: {
                        this.addBranchStatusDecorator((List<DiagramLabelProvider.NodeDecorator>)nodeDecorators, node, direction, (Connectable<?>)this.network.getBranch(feederNode.getEquipmentId()));
                        break;
                    }
                    case THREE_WINDINGS_TRANSFORMER_LEG: {
                        if (!node.getAdjacentNodes().stream().noneMatch(Middle3WTNode.class::isInstance)) break;
                        this.addBranchStatusDecorator((List<DiagramLabelProvider.NodeDecorator>)nodeDecorators, node, direction, (Connectable<?>)this.network.getThreeWindingsTransformer(feederNode.getEquipmentId()));
                        break;
                    }
                    case HVDC: {
                        HvdcLine hvdcLine = this.network.getHvdcLine(feederNode.getEquipmentId());
                        HvdcConverterStation converterStation = ((FeederWithSides)feederNode.getFeeder()).getSide() == NodeSide.ONE ? hvdcLine.getConverterStation1() : hvdcLine.getConverterStation2();
                        this.addBranchStatusDecorator((List<DiagramLabelProvider.NodeDecorator>)nodeDecorators, node, direction, (Connectable<?>)converterStation);
                        break;
                    }
                }
            } else if (node instanceof MiddleTwtNode) {
                if (node instanceof Middle3WTNode && ((Middle3WTNode)node).isEmbeddedInVlGraph()) {
                    this.addBranchStatusDecorator((List<DiagramLabelProvider.NodeDecorator>)nodeDecorators, node, direction, (Connectable<?>)this.network.getThreeWindingsTransformer(((Middle3WTNode)node).getEquipmentId()));
                }
            } else {
                Identifiable identifiable = this.network.getIdentifiable(((EquipmentNode)node).getEquipmentId());
                if (identifiable instanceof Connectable) {
                    this.addBranchStatusDecorator(nodeDecorators, node, direction, (Connectable)identifiable);
                }
            }
        }
        return nodeDecorators;
    }

    @Override
    public List<ElectricalNodeInfo> getElectricalNodesInfos(VoltageLevelGraph graph) {
        VoltageLevel vl = this.network.getVoltageLevel(graph.getVoltageLevelInfos().getId());
        return vl.getBusView().getBusStream().map(b -> new ElectricalNodeInfo(b.getId(), b.getV(), b.getAngle())).collect(Collectors.toList());
    }

    private void addBranchStatusDecorator(List<DiagramLabelProvider.NodeDecorator> nodeDecorators, Node node, Direction direction, Connectable<?> c) {
        BranchStatus branchStatus = (BranchStatus)c.getExtension(BranchStatus.class);
        if (branchStatus != null) {
            switch (branchStatus.getStatus()) {
                case PLANNED_OUTAGE: {
                    nodeDecorators.add(this.getBranchStatusDecorator(node, direction, PLANNED_OUTAGE_BRANCH_NODE_DECORATOR));
                    break;
                }
                case FORCED_OUTAGE: {
                    nodeDecorators.add(this.getBranchStatusDecorator(node, direction, FORCED_OUTAGE_BRANCH_NODE_DECORATOR));
                    break;
                }
            }
        }
    }

    private DiagramLabelProvider.NodeDecorator getBranchStatusDecorator(Node node, Direction direction, String decoratorType) {
        return node instanceof Middle3WTNode ? new DiagramLabelProvider.NodeDecorator(decoratorType, this.getMiddle3WTDecoratorPosition((Middle3WTNode)node, direction)) : new DiagramLabelProvider.NodeDecorator(decoratorType, this.getFeederDecoratorPosition(direction, decoratorType));
    }

    private List<FeederInfo> buildFeederInfos(ThreeWindingsTransformer transformer, ThreeWindingsTransformer.Side side) {
        return this.buildFeederInfos(transformer.getTerminal(side));
    }

    private List<FeederInfo> buildFeederInfos(Injection<?> injection) {
        return this.buildFeederInfos(injection.getTerminal());
    }

    private List<FeederInfo> buildFeederInfos(Branch<?> branch, Branch.Side side) {
        return this.buildFeederInfos(branch.getTerminal(side));
    }

    private List<FeederInfo> buildFeederInfos(HvdcLine hvdcLine, NodeSide side) {
        HvdcConverterStation hvdcConverterStation = side == NodeSide.ONE ? hvdcLine.getConverterStation1() : hvdcLine.getConverterStation2();
        return this.buildFeederInfos(hvdcConverterStation.getTerminal());
    }

    private List<FeederInfo> buildFeederInfos(Terminal terminal) {
        ArrayList<FeederInfo> feederInfoList = new ArrayList<FeederInfo>();
        feederInfoList.add(new DirectionalFeederInfo("ARROW_ACTIVE", terminal.getP(), arg_0 -> ((ValueFormatter)this.valueFormatter).formatPower(arg_0)));
        feederInfoList.add(new DirectionalFeederInfo("ARROW_REACTIVE", terminal.getQ(), arg_0 -> ((ValueFormatter)this.valueFormatter).formatPower(arg_0)));
        if (this.layoutParameters.isDisplayCurrentFeederInfo()) {
            feederInfoList.add(new DirectionalFeederInfo("ARROW_CURRENT", terminal.getI(), arg_0 -> ((ValueFormatter)this.valueFormatter).formatCurrent(arg_0)));
        }
        return feederInfoList;
    }
}

